package vazkii.botania.mixin;

import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_5281;
import net.minecraft.class_5444;
import net.minecraft.class_5539;
import net.minecraft.class_5868;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.world.SkyblockChunkGenerator;

/**
 * Based on code from CarpetSkyAdditions. Ensures terrain-sensitive structures generate where they should.
 */
@Mixin(class_5444.class)
public class PlacementContextMixin extends class_5868 {
	@Shadow
	@Final
	private class_2794 generator;

	@Shadow
	@Final
	private class_5281 level;

	public PlacementContextMixin(class_2794 generator, class_5539 levelHeightAccessor) {
		super(generator, levelHeightAccessor);
	}

	/**
	 * For Garden of Glass, use generation heightmap instead of empty actual heightmap to place features/structures.
	 */
	@Inject(method = "getHeight", cancellable = true, at = @At("HEAD"))
	private void useGenerationHeightmap(class_2902.class_2903 heightmap, int x, int z, CallbackInfoReturnable<Integer> cir) {
		if (generator instanceof SkyblockChunkGenerator skyblockChunkGenerator) {
			cir.setReturnValue(skyblockChunkGenerator.getBaseHeightInEquivalentNoiseWorld(x, z, heightmap, level));
		}
	}
}
