package vazkii.botania.mixin;

import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1399;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1399.class)
public class HurtByTargetGoalMixin {
	/**
	 * Prevent mobs from punching themselves. This can happen when either the Heisei Dream or Diva Charm brainwash
	 * another mob and that mob alerts other mobs to attack the same target. If the target is among the alerted mobs,
	 * it would attack itself.
	 * TODO[MixinExtras] Preventing the call in HurtByTargetGoal::alertOthers would be a more compatible option.
	 */
	@Inject(method = "alertOther", at = @At("HEAD"), cancellable = true)
	private void checkSelfTargeting(class_1308 mobToAlert, class_1309 targetToAttack, CallbackInfo ci) {
		if (mobToAlert == targetToAttack) {
			ci.cancel();
		}
	}
}
