/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block.PhantomInkableBlock;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1684;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import net.minecraft.class_5712;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class LuminizerBlockEntity extends BotaniaBlockEntity implements WandBindable, PhantomInkableBlock {
	public static final int MAX_DIST = 20;

	private static final String TAG_BIND_X = "bindX";
	private static final String TAG_BIND_Y = "bindY";
	private static final String TAG_BIND_Z = "bindZ";
	private static final String TAG_NO_PARTICLE = "noParticle";

	private class_2338 bindPos = Bound.UNBOUND_POS;
	private int ticksElapsed = 0;
	private boolean noParticle = false;

	public LuminizerBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.LIGHT_RELAY, pos, state);
	}

	public void mountEntity(class_1297 e) {
		class_2338 nextDest = getNextDestination();
		if (e.method_5765() || field_11863.field_9236 || nextDest == null || !isValidBinding()) {
			return;
		}

		PlayerMoverEntity mover = new PlayerMoverEntity(field_11863, field_11867, nextDest);
		field_11863.method_8649(mover);
		e.method_5804(mover);
		if (!(e instanceof class_1542)) {
			mover.method_5783(BotaniaSounds.lightRelay, 1F, (float) Math.random() * 0.3F + 0.7F);
		}
		if (e instanceof class_3222 serverPlayer) {
			PlayerHelper.grantCriterion(serverPlayer, prefix("main/luminizer_ride"), "code_triggered");
		}
	}

	public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, LuminizerBlockEntity self) {
		self.ticksElapsed++;

		class_2338 nextDest = self.getNextDestination();
		if (!self.isNoParticle() && nextDest != null && nextDest.method_10264() != Integer.MIN_VALUE && self.isValidBinding()) {
			class_243 vec = self.getMovementVector();
			if (vec != null) {
				double dist = 0.1;
				int size = (int) (vec.method_1033() / dist);
				int count = 10;
				int start = self.ticksElapsed % size;

				class_243 vecMag = vec.method_1029().method_1021(dist);
				class_243 vecTip = vecMag.method_1021(start).method_1031(worldPosition.method_10263() + 0.5, worldPosition.method_10264() + 0.5, worldPosition.method_10260() + 0.5);

				double radPer = Math.PI / 16.0;
				float mul = 0.5F;
				float mulPer = 0.4F;
				float maxMul = 2;
				WispParticleData data = WispParticleData.wisp(0.1F, 0.4F, 0.4F, 1F, 1);
				for (int i = start; i < start + count; i++) {
					mul = Math.min(maxMul, mul + mulPer);
					double rad = radPer * (i + self.ticksElapsed * 0.4);
					class_243 intermediate = vecMag.method_1036(VecHelper.ONE).method_1021(mul);
					class_243 vecRot = VecHelper.rotate(intermediate, rad, vecMag).method_1019(vecTip);
					level.method_8406(data, vecRot.field_1352, vecRot.field_1351, vecRot.field_1350, (float) -vecMag.field_1352, (float) -vecMag.field_1351, (float) -vecMag.field_1350);
					vecTip = vecTip.method_1019(vecMag);
				}
			}
		}
	}

	public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, LuminizerBlockEntity self) {
		self.ticksElapsed++;

		class_2338 nextDest = self.getNextDestination();
		if (nextDest != null && nextDest.method_10264() != Integer.MIN_VALUE && self.isValidBinding()) {
			class_2338 endpoint = self.getEndpoint();

			if (endpoint != null) {
				class_238 aabb = state.method_26218(level, worldPosition).method_1107().method_996(worldPosition);
				float range = 0.6F;
				List<class_1684> enderPearls = level.method_18467(class_1684.class, aabb.method_1014(range));
				for (class_1684 pearl : enderPearls) {
					pearl.method_5859(
							endpoint.method_10263() + pearl.method_23317() - worldPosition.method_10263(),
							endpoint.method_10264() + pearl.method_23318() - worldPosition.method_10264(),
							endpoint.method_10260() + pearl.method_23321() - worldPosition.method_10260()
					);
				}
			}
		}
	}

	private boolean isValidBinding() {
		class_2338 nextDest = getNextDestination();
		if (nextDest == null) {
			return false;
		}

		class_2248 block = field_11863.method_8320(nextDest).method_26204();
		return block instanceof LuminizerBlock;
	}

	private class_2338 getEndpoint() {
		List<LuminizerBlockEntity> pointsPassed = new ArrayList<>();
		LuminizerBlockEntity relay = this;
		class_2338 lastCoords = null;

		// Doing while(true) gives an unreachable code error
		boolean run = true;
		while (run) {
			if (pointsPassed.contains(relay)) {
				return null; // Circular path
			}
			pointsPassed.add(relay);

			class_2338 coords = relay.getNextDestination();
			if (coords == null) {
				return lastCoords;
			}

			class_2586 tile = field_11863.method_8321(coords);
			if (tile != null && tile instanceof LuminizerBlockEntity tileRelay) {
				relay = tileRelay;
			} else {
				return lastCoords;
			}

			lastCoords = coords;
		}

		return null;
	}

	public void setNoParticle() {
		noParticle = true;
		method_5431();
	}

	public boolean isNoParticle() {
		return noParticle;
	}

	public class_243 getMovementVector() {
		class_2338 dest = getNextDestination();
		if (dest == null) {
			return null;
		}

		return new class_243(dest.method_10263() - field_11867.method_10263(), dest.method_10264() - field_11867.method_10264(), dest.method_10260() - field_11867.method_10260());
	}

	@Override
	public class_2338 getBinding() {
		return bindPos;
	}

	public class_2338 getNextDestination() {
		class_2680 state = method_11010();
		if (state.method_27852(BotaniaBlocks.lightRelayToggle) && state.method_11654(class_2741.field_12484)) {
			return null;
		} else if (state.method_27852(BotaniaBlocks.lightRelayFork)) {
			class_2338 torchPos = null;
			for (int i = -2; i < 3; i++) {
				class_2338 testPos = field_11867.method_10069(0, i, 0);

				class_2680 testState = field_11863.method_8320(testPos);
				if (testState.method_27852(BotaniaBlocks.animatedTorch)) {
					torchPos = testPos;
					break;
				}
			}

			if (torchPos != null) {
				AnimatedTorchBlockEntity torch = (AnimatedTorchBlockEntity) field_11863.method_8321(torchPos);
				class_2350 side = AnimatedTorchBlockEntity.SIDES[torch.side].method_10153();
				for (int i = 1; i < MAX_DIST; i++) {
					class_2338 testPos = field_11867.method_10079(side, i);
					class_2680 testState = field_11863.method_8320(testPos);
					if (testState.method_26204() instanceof LuminizerBlock) {
						return testPos;
					}
				}
			}
		}

		return getBinding();
	}

	@Override
	public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		return true;
	}

	@Override
	public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		if (!(player.method_37908().method_8320(pos).method_26204() instanceof LuminizerBlock)
				|| pos.method_10262(method_11016()) > MAX_DIST * MAX_DIST) {
			return false;
		}

		bindPos = pos;
		method_5431();
		VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		return true;
	}

	@Override
	public boolean onPhantomInked(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
		if (isNoParticle()) {
			return false;
		}
		if (!field_11863.field_9236) {
			if (player == null || !player.method_31549().field_7477) {
				stack.method_7934(1);
			}
			setNoParticle();
			field_11863.method_33596(null, class_5712.field_28733, method_11016());
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
		return true;
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		bindPos = new class_2338(
				cmp.method_10550(TAG_BIND_X),
				cmp.method_10550(TAG_BIND_Y),
				cmp.method_10550(TAG_BIND_Z)
		);
		noParticle = cmp.method_10577(TAG_NO_PARTICLE);
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_BIND_X, bindPos.method_10263());
		cmp.method_10569(TAG_BIND_Y, bindPos.method_10264());
		cmp.method_10569(TAG_BIND_Z, bindPos.method_10260());
		cmp.method_10556(TAG_NO_PARTICLE, noParticle);
	}

	public static class PlayerMoverEntity extends class_1297 {
		private static final String TAG_EXIT_X = "exitX";
		private static final String TAG_EXIT_Y = "exitY";
		private static final String TAG_EXIT_Z = "exitZ";
		private static final class_2940<class_2338> EXIT_POS = class_2945.method_12791(PlayerMoverEntity.class, class_2943.field_13324);

		public PlayerMoverEntity(class_1299<PlayerMoverEntity> type, class_1937 world) {
			super(type, world);
			field_5960 = true;
		}

		public PlayerMoverEntity(class_1937 world, class_2338 pos, class_2338 exitPos) {
			this(BotaniaEntities.PLAYER_MOVER, world);
			method_5814(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5);
			setExit(exitPos);
		}

		@Override
		protected void method_5693() {
			field_6011.method_12784(EXIT_POS, ManaBurst.NO_SOURCE);
		}

		@Override
		public void method_5773() {
			super.method_5773();

			if (method_5685().isEmpty() && !method_37908().field_9236) {
				method_31472();
				return;
			}

			boolean isItem = method_5685().stream().allMatch(class_1542.class::isInstance);
			if (!isItem && field_6012 % 30 == 0) {
				method_5783(BotaniaSounds.lightRelay, 0.25F, (float) Math.random() * 0.3F + 0.7F);
			}
			if (!isItem && field_6012 % 10 == 0) {
				method_32876(class_5712.field_28158);
			}

			class_2338 pos = method_24515();
			class_2338 exitPos = getExitPos();

			if (!method_37908().field_9236 && pos.equals(exitPos)) {
				boolean done = true;
				class_2586 tile = method_37908().method_8321(pos);
				if (tile instanceof LuminizerBlockEntity relay) {
					class_2680 state = method_37908().method_8320(pos);
					if (state.method_27852(BotaniaBlocks.lightRelayDetector)) {
						method_37908().method_8501(pos, state.method_11657(class_2741.field_12484, true));
						method_37908().method_39279(pos, state.method_26204(), 2);
					}

					class_2338 bind = relay.getNextDestination();
					if (bind != null && relay.isValidBinding()) {
						setExit(bind);
						done = false;
					}
				}

				if (done) {
					for (class_1297 e : method_5685()) {
						e.method_5848();
					}
					method_31472();
					return;
				}
			}
			class_243 thisVec = method_19538();
			class_243 motVec = thisVec.method_22882().method_1031(exitPos.method_10263() + 0.5, exitPos.method_10264() + 0.5, exitPos.method_10260() + 0.5).method_1029().method_1021(0.5);

			int color;

			int count = 4;
			for (int i = 0; i < count; i++) {
				color = class_3532.method_15369(field_6012 / 36F + 1F / count * i, 1F, 1F);
				double rad = Math.PI * 2.0 / count * i + field_6012 / Math.PI;
				double cos = Math.cos(rad);
				double sin = Math.sin(rad);
				double s = 0.4;

				int r = (color >> 16) & 0xFF;
				int g = (color >> 8) & 0xFF;
				int b = color & 0xFF;
				SparkleParticleData data = SparkleParticleData.sparkle(1.2F, r / 255F, g / 255F, b / 255F, 10);
				method_37908().method_8406(data, method_23317() + cos * s, method_23318() - 0.5, method_23321() + sin * s, 0, 0, 0);
			}

			method_5814(method_23317() + motVec.field_1352, method_23318() + motVec.field_1351, method_23321() + motVec.field_1350);
		}

		@SoftImplement("IForgeEntity") // todo implement on fabric
		public boolean shouldRiderSit() {
			return false;
		}

		@Override
		public boolean method_5643(@NotNull class_1282 source, float damage) {
			return false;
		}

		@Override
		protected void method_5749(@NotNull class_2487 cmp) {
			setExit(new class_2338(cmp.method_10550(TAG_EXIT_X), cmp.method_10550(TAG_EXIT_Y), cmp.method_10550(TAG_EXIT_Z)));
		}

		@Override
		protected void method_5652(@NotNull class_2487 cmp) {
			class_2338 exit = getExitPos();
			cmp.method_10569(TAG_EXIT_X, exit.method_10263());
			cmp.method_10569(TAG_EXIT_Y, exit.method_10264());
			cmp.method_10569(TAG_EXIT_Z, exit.method_10260());
		}

		// [VanillaCopy] Pig logic to select a dismount location
		@Override
		public class_243 method_24829(class_1309 living) {
			class_2350 direction = living.method_5735();
			int[][] aint = class_5275.method_27934(direction);
			class_2338 blockpos = this.method_24515();
			class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();

			for (class_4050 pose : living.method_24831()) {
				class_238 axisalignedbb = living.method_24833(pose);

				for (int[] aint1 : aint) {
					blockpos$mutable.method_10103(blockpos.method_10263() + aint1[0], blockpos.method_10264(), blockpos.method_10260() + aint1[1]);
					double d0 = this.method_37908().method_30347(blockpos$mutable);
					if (class_5275.method_27932(d0)) {
						class_243 vector3d = class_243.method_26410(blockpos$mutable, d0);
						if (class_5275.method_27933(this.method_37908(), living, axisalignedbb.method_997(vector3d))) {
							living.method_18380(pose);
							return vector3d;
						}
					}
				}
			}

			return super.method_24829(living);
		}

		@Override
		public class_2596<class_2602> method_18002() {
			return new class_2604(this);
		}

		public class_2338 getExitPos() {
			return field_6011.method_12789(EXIT_POS);
		}

		public void setExit(class_2338 pos) {
			field_6011.method_12778(EXIT_POS, pos);
		}

	}

}
