/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import vazkii.botania.common.entity.ManaSparkEntity;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_310;
import net.minecraft.class_5617;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ManaSparkRenderer extends BaseSparkRenderer<ManaSparkEntity> {
	private final class_1058 dispersiveIcon;
	private final class_1058 dominantIcon;
	private final class_1058 recessiveIcon;
	private final class_1058 isolatedIcon;

	public ManaSparkRenderer(class_5617.class_5618 ctx) {
		super(ctx);
		var atlas = class_310.method_1551().method_1549(class_1723.field_21668);
		this.dispersiveIcon = Objects.requireNonNull(atlas.apply(prefix("item/spark_upgrade_rune_dispersive")));
		this.dominantIcon = Objects.requireNonNull(atlas.apply(prefix("item/spark_upgrade_rune_dominant")));
		this.recessiveIcon = Objects.requireNonNull(atlas.apply(prefix("item/spark_upgrade_rune_recessive")));
		this.isolatedIcon = Objects.requireNonNull(atlas.apply(prefix("item/spark_upgrade_rune_isolated")));
	}

	@Override
	public class_1058 getSpinningIcon(ManaSparkEntity entity) {
		return switch (entity.getUpgrade()) {
			case NONE -> null;
			case DISPERSIVE -> this.dispersiveIcon;
			case DOMINANT -> this.dominantIcon;
			case RECESSIVE -> this.recessiveIcon;
			case ISOLATED -> this.isolatedIcon;
		};
	}

}
