/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.network.clientbound;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.GrassSeedsItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.network.EffectType;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import ;
import D;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;

// Prefer using World.addBlockEvent/Block.eventReceived/TileEntity.receiveClientEvent where possible
// as those use less network bandwidth (~14 bytes), vs 26+ bytes here
public record BotaniaEffectPacket(EffectType type, double x, double y, double z, int... args) implements BotaniaPacket {

	public static final class_2960 ID = prefix("eff");
	private static final int MAX_VARIABLE_ARGS = 128;

	@Override
	public void encode(class_2540 buf) {
		buf.writeByte(type().ordinal());
		buf.writeDouble(x());
		buf.writeDouble(y());
		buf.writeDouble(z());

		if (type().argCount != -1 && type().argCount != args().length) {
			throw new IllegalArgumentException("Argument count mismatch");
		}

		if (type().argCount == -1) {
			if (args().length > MAX_VARIABLE_ARGS) {
				throw new IllegalArgumentException("Too many variable arguments");
			}
			buf.method_10804(args().length);
		}
		for (int arg : args) {
			buf.method_10804(arg);
		}
	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	public static BotaniaEffectPacket decode(class_2540 buf) {
		EffectType type = EffectType.values()[buf.readByte()];
		double x = buf.readDouble();
		double y = buf.readDouble();
		double z = buf.readDouble();
		int argCount;
		if (type.argCount == -1) {
			argCount = buf.method_10816();
			if (argCount > MAX_VARIABLE_ARGS) {
				throw new IllegalArgumentException("Too many variable arguments");
			}
		} else {
			argCount = type.argCount;
		}
		int[] args = new int[argCount];

		for (int i = 0; i < args.length; i++) {
			args[i] = buf.method_10816();
		}

		return new BotaniaEffectPacket(type, x, y, z, args);
	}

	public static class Handler {
		public static void handle(BotaniaEffectPacket packet) {
			var type = packet.type();
			var x = packet.x();
			var y = packet.y();
			var z = packet.z();
			var args = packet.args();
			class_310 mc = class_310.method_1551();
			// Lambda trips verifier on forge
			mc.execute(new Runnable() {
				@Override
				public void run() {
					class_1937 world = mc.field_1687;
					switch (type) {
						case PAINT_LENS -> {
							class_1767 placeColor = class_1767.method_7791(args[0]);
							int hex = ColorHelper.getColorValue(placeColor);
							int r = (hex & 0xFF0000) >> 16;
							int g = (hex & 0xFF00) >> 8;
							int b = hex & 0xFF;
							for (int i = 0; i < 10; i++) {
								class_2338 pos = class_2338.method_49637(x, y, z).method_10093(class_2350.method_10162(world.field_9229));
								SparkleParticleData data = SparkleParticleData.sparkle(0.6F + (float) Math.random() * 0.5F, r / 255F, g / 255F, b / 255F, 5);
								world.method_8406(data, pos.method_10263() + (float) Math.random(), pos.method_10264() + (float) Math.random(), pos.method_10260() + (float) Math.random(), 0, 0, 0);
							}
						}
						case ARENA_INDICATOR -> {
							SparkleParticleData data = SparkleParticleData.sparkle(5F, 1, 0, 1, 120);
							for (int i = 0; i < 360; i += 8) {
								float rad = i * (float) Math.PI / 180F;
								double wx = x + 0.5 - Math.cos(rad) * GaiaGuardianEntity.ARENA_RANGE;
								double wy = y + 0.5;
								double wz = z + 0.5 - Math.sin(rad) * GaiaGuardianEntity.ARENA_RANGE;
								Proxy.INSTANCE.addParticleForceNear(world, data, wx, wy, wz, 0, 0, 0);
							}
						}
						case ITEM_SMOKE -> {
							class_1297 item = world.method_8469(args[0]);
							if (item == null) {
								return;
							}

							int p = args[1];

							for (int i = 0; i < p; i++) {
								double m = 0.01;
								double d0 = item.method_37908().field_9229.method_43059() * m;
								double d1 = item.method_37908().field_9229.method_43059() * m;
								double d2 = item.method_37908().field_9229.method_43059() * m;
								double d3 = 10.0D;
								item.method_37908().method_8406(class_2398.field_11203,
										x + item.method_37908().field_9229.method_43057() * item.method_17681() * 2.0F - item.method_17681() - d0 * d3, y + item.method_37908().field_9229.method_43057() * item.method_17682() - d1 * d3,
										z + item.method_37908().field_9229.method_43057() * item.method_17681() * 2.0F - item.method_17681() - d2 * d3, d0, d1, d2);
							}
						}
						case SPARK_NET_INDICATOR -> {
							class_1297 e1 = world.method_8469(args[0]);
							class_1297 e2 = world.method_8469(args[1]);

							if (e1 == null || e2 == null) {
								return;
							}

							class_243 orig = new class_243(e1.method_23317(), e1.method_23318() + 0.25, e1.method_23321());
							class_243 end = new class_243(e2.method_23317(), e2.method_23318() + 0.25, e2.method_23321());
							class_243 diff = end.method_1020(orig);
							class_243 movement = diff.method_1029().method_1021(0.1);
							int iters = (int) (diff.method_1033() / movement.method_1033());
							float huePer = 1F / iters;
							float hueSum = (float) Math.random();

							class_243 currentPos = orig;
							for (int i = 0; i < iters; i++) {
								float hue = i * huePer + hueSum;
								int color = class_3532.method_15369(class_3532.method_22450(hue), 1F, 1F);
								float r = Math.min(1F, (color >> 16 & 0xFF) / 255F + 0.4F);
								float g = Math.min(1F, (color >> 8 & 0xFF) / 255F + 0.4F);
								float b = Math.min(1F, (color & 0xFF) / 255F + 0.4F);

								SparkleParticleData data = SparkleParticleData.noClip(1, r, g, b, 12);
								world.method_17452(data, true, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 0, 0, 0);
								currentPos = currentPos.method_1019(movement);
							}

						}
						case SPARK_MANA_FLOW -> {
							class_1297 e1 = world.method_8469(args[0]);
							class_1297 e2 = world.method_8469(args[1]);

							if (e1 == null || e2 == null) {
								return;
							}

							double rc = 0.45;
							class_243 thisVec = VecHelper.fromEntityCenter(e1).method_1031((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
							class_243 receiverVec = VecHelper.fromEntityCenter(e2).method_1031((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);

							class_243 motion = receiverVec.method_1020(thisVec).method_1021(0.04F);
							int color = args[2];
							float r = ((color >> 16) & 0xFF) / 255.0F;
							float g = ((color >> 8) & 0xFF) / 255.0F;
							float b = (color & 0xFF) / 255.0F;
							if (world.field_9229.method_43057() < 0.25) {
								r += 0.2F * (float) world.field_9229.method_43059();
								g += 0.2F * (float) world.field_9229.method_43059();
								b += 0.2F * (float) world.field_9229.method_43059();
							}
							float size = 0.125F + 0.125F * (float) Math.random();

							WispParticleData data = WispParticleData.wisp(size, r, g, b).withNoClip(true);
							world.method_8494(data, thisVec.field_1352, thisVec.field_1351, thisVec.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
						}
						case ENCHANTER_DESTROY -> {
							for (int i = 0; i < 50; i++) {
								float red = (float) Math.random();
								float green = (float) Math.random();
								float blue = (float) Math.random();
								WispParticleData data = WispParticleData.wisp((float) Math.random() * 0.15F + 0.15F, red, green, blue);
								world.method_8406(data, x, y, z, (float) (Math.random() - 0.5F) * 0.25F, (float) (Math.random() - 0.5F) * 0.25F, (float) (Math.random() - 0.5F) * 0.25F);
							}
						}
						case BLACK_LOTUS_DISSOLVE -> {
							for (int i = 0; i < 50; i++) {
								float r = (float) Math.random() * 0.35F;
								float g = 0F;
								float b = (float) Math.random() * 0.35F;
								float s = 0.45F * (float) Math.random() * 0.25F;

								float m = 0.045F;
								float mx = ((float) Math.random() - 0.5F) * m;
								float my = (float) Math.random() * m;
								float mz = ((float) Math.random() - 0.5F) * m;

								WispParticleData data = WispParticleData.wisp(s, r, g, b);
								world.method_8406(data, x, y, z, mx, my, mz);
							}

						}
						case TERRA_PLATE -> {
							class_2586 te = world.method_8321(class_2338.method_49637(x, y, z));
							if (te instanceof TerrestrialAgglomerationPlateBlockEntity) {
								float percentage = Float.intBitsToFloat(args[0]);
								int ticks = (int) (100.0 * percentage);

								int totalSpiritCount = 3;
								double tickIncrement = 360D / totalSpiritCount;

								int speed = 5;
								double wticks = ticks * speed - tickIncrement;

								double r = Math.sin((ticks - 100) / 10D) * 2;
								double g = Math.sin(wticks * Math.PI / 180 * 0.55);

								for (int i = 0; i < totalSpiritCount; i++) {
									double wx = x + Math.sin(wticks * Math.PI / 180) * r + 0.5;
									double wy = y + 0.25 + Math.abs(r) * 0.7;
									double wz = z + Math.cos(wticks * Math.PI / 180) * r + 0.5;

									wticks += tickIncrement;
									float[] colorsfx = new float[] {
											0F, (float) ticks / (float) 100, 1F - (float) ticks / (float) 100
									};
									WispParticleData data = WispParticleData.wisp(0.85F, colorsfx[0], colorsfx[1], colorsfx[2], 0.25F);
									Proxy.INSTANCE.addParticleForceNear(world, data, wx, wy, wz, 0, (float) (-g * 0.05), 0);
									data = WispParticleData.wisp((float) Math.random() * 0.1F + 0.1F, colorsfx[0], colorsfx[1], colorsfx[2], 0.9F);
									world.method_8406(data, wx, wy, wz, (float) (Math.random() - 0.5) * 0.05F, (float) (Math.random() - 0.5) * 0.05F, (float) (Math.random() - 0.5) * 0.05F);

									if (ticks == 100) {
										for (int j = 0; j < 15; j++) {
											data = WispParticleData.wisp((float) Math.random() * 0.15F + 0.15F, colorsfx[0], colorsfx[1], colorsfx[2]);
											world.method_8406(data, x + 0.5, y + 0.5, z + 0.5, (float) (Math.random() - 0.5F) * 0.125F, (float) (Math.random() - 0.5F) * 0.125F, (float) (Math.random() - 0.5F) * 0.125F);
										}
									}
								}
							}
						}
						case FLUGEL_EFFECT -> {
							class_1297 entity = world.method_8469(args[0]);
							if (entity != null) {
								for (int i = 0; i < 15; i++) {
									float x1 = (float) (entity.method_23317() + Math.random());
									float y1 = (float) (entity.method_23318() + Math.random());
									float z1 = (float) (entity.method_23321() + Math.random());
									WispParticleData data = WispParticleData.wisp((float) Math.random(), (float) Math.random(), (float) Math.random(), (float) Math.random(), 1);
									world.method_8406(data, x1, y1, z1, 0, -(-0.3F + (float) Math.random() * 0.2F), 0);
								}
							}
						}
						case PARTICLE_BEAM -> {
							WandOfTheForestItem.doParticleBeam(world,
									new class_243(x, y, z),
									new class_243(args[0] + 0.5, args[1] + 0.5, args[2] + 0.5));
						}
						case DIVA_EFFECT -> {
							class_1297 target = world.method_8469(args[0]);
							if (target == null) {
								break;
							}

							double x1 = target.method_23317();
							double y1 = target.method_23318();
							double z1 = target.method_23321();

							SparkleParticleData data = SparkleParticleData.sparkle(1F, 1F, 1F, 0.25F, 3);
							for (int i = 0; i < 50; i++) {
								world.method_8406(data, x1 + Math.random() * target.method_17681(), y1 + Math.random() * target.method_17682(), z1 + Math.random() * target.method_17681(), 0, 0, 0);
							}
						}
						case HALO_CRAFT -> {
							class_1297 target = world.method_8469(args[0]);
							if (target != null) {
								class_243 lookVec3 = target.method_5720();
								class_243 centerVector = VecHelper.fromEntityCenter(target).method_1031(lookVec3.field_1352 * 3, 1.3, lookVec3.field_1350 * 3);
								float m = 0.1F;
								for (int i = 0; i < 4; i++) {
									WispParticleData data = WispParticleData.wisp(0.2F + 0.2F * (float) Math.random(), 1F, 0F, 1F);
									target.method_37908().method_8406(data, centerVector.field_1352, centerVector.field_1351, centerVector.field_1350, ((float) Math.random() - 0.5F) * m, ((float) Math.random() - 0.5F) * m, ((float) Math.random() - 0.5F) * m);
								}
							}

						}
						case AVATAR_TORNADO_JUMP -> {
							class_1297 p = world.method_8469(args[0]);
							if (p != null) {
								for (int i = 0; i < 20; i++) {
									for (int j = 0; j < 5; j++) {
										WispParticleData data = WispParticleData.wisp(0.35F + (float) Math.random() * 0.1F, 0.25F, 0.25F, 0.25F);
										world.method_8406(data, p.method_23317(),
												p.method_23318() + i, p.method_23321(),
												0.2F * (float) (Math.random() - 0.5),
												-0.01F * (float) Math.random(),
												0.2F * (float) (Math.random() - 0.5));
									}
								}
							}
						}
						case AVATAR_TORNADO_BOOST -> {
							class_1297 p = world.method_8469(args[0]);
							if (p != null) {
								class_243 lookDir = p.method_5720();
								for (int i = 0; i < 20; i++) {
									for (int j = 0; j < 5; j++) {
										WispParticleData data = WispParticleData.wisp(0.35F + (float) Math.random() * 0.1F, 0.25F, 0.25F, 0.25F);
										world.method_8406(data, p.method_23317() + lookDir.method_10216() * i,
												p.method_23318() + lookDir.method_10214() * i,
												p.method_23321() + lookDir.method_10215() * i,
												0.2F * (float) (Math.random() - 0.5) * (Math.abs(lookDir.method_10214()) + Math.abs(lookDir.method_10215())) + -0.01F * (float) Math.random() * lookDir.method_10216(),
												0.2F * (float) (Math.random() - 0.5) * (Math.abs(lookDir.method_10216()) + Math.abs(lookDir.method_10215())) + -0.01F * (float) Math.random() * lookDir.method_10214(),
												0.2F * (float) (Math.random() - 0.5) * (Math.abs(lookDir.method_10214()) + Math.abs(lookDir.method_10216())) + -0.01F * (float) Math.random() * lookDir.method_10215());
									}
								}
							}
						}
						case THUNDERCALLER_EFFECT -> {
							class_243 source = new class_243(x, y, z);
							for (int id : args) {
								var entity = world.method_8469(id);
								if (entity == null) {
									break;
								}
								var entityPos = VecHelper.fromEntityCenter(entity);
								Proxy.INSTANCE.lightningFX(world, source, entityPos, 1, 0x0179C4, 0xAADFFF);
								source = entityPos;
							}
						}
						case GRASS_SEED_PARTICLES -> {
							int color = args[0];
							GrassSeedsItem.spawnParticles(world, class_2338.method_49637(x, y, z),
									GrassSeedsItem.extractR(color), GrassSeedsItem.extractG(color), GrassSeedsItem.extractB(color));
						}
					}
				}
			});
		}
	}

}
