package vazkii.botania.fabric.integration.rei;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.client.integration.shared.OrechidUIHelper;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

import java.util.stream.Stream;
import net.minecraft.class_2561;

public class MarimorphosisREICategory extends OrechidREICategory {
	public MarimorphosisREICategory() {
		super(BotaniaREICategoryIdentifiers.MARIMORPHOSIS, BotaniaFlowerBlocks.marimorphosis);
	}

	@NotNull
	@Override
	protected Stream<class_2561> getChanceTooltipComponents(double chance, OrechidRecipe recipe) {
		Stream<class_2561> genericChanceTooltipComponents = super.getChanceTooltipComponents(chance, recipe);
		Stream<class_2561> biomeChanceTooltipComponents = OrechidUIHelper.getBiomeChanceAndRatioTooltipComponents(chance, recipe);
		return Stream.concat(genericChanceTooltipComponents, biomeChanceTooltipComponents);
	}
}
