/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2521;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.xplat.BotaniaConfig;

public class BotaniaDoubleFlowerBlock extends class_2521 {
	public final class_1767 color;

	public BotaniaDoubleFlowerBlock(class_1767 color, class_2251 builder) {
		super(builder);
		this.color = color;
	}

	@Override
	public boolean method_9651(@NotNull class_4538 world, @NotNull class_2338 pos, @NotNull class_2680 state, boolean fuckifiknow) {
		return false;
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		int hex = MysticalPetalItem.getPetalLikeColor(color);
		int r = (hex & 0xFF0000) >> 16;
		int g = (hex & 0xFF00) >> 8;
		int b = hex & 0xFF;

		if (rand.method_43058() < BotaniaConfig.client().flowerParticleFrequency()) {
			SparkleParticleData data = SparkleParticleData.sparkle(rand.method_43057(), r / 255F, g / 255F, b / 255F, 5);
			world.method_8406(data, pos.method_10263() + 0.3 + rand.method_43057() * 0.5, pos.method_10264() + 0.5 + rand.method_43057() * 0.5, pos.method_10260() + 0.3 + rand.method_43057() * 0.5, 0, 0, 0);
		}

	}
}
