/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;

import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

// Catch-all "used an item and it succeeded" trigger for Botania items, because making a separate
// trigger for each one is dumb.
public class UseItemSuccessTrigger extends class_4558<UseItemSuccessTrigger.Instance> {
	public static final class_2960 ID = prefix("use_item_success");
	public static final UseItemSuccessTrigger INSTANCE = new UseItemSuccessTrigger();

	private UseItemSuccessTrigger() {}

	@NotNull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@NotNull
	@Override
	public UseItemSuccessTrigger.Instance method_27854(@NotNull JsonObject json, @NotNull class_5258 playerPred, class_5257 conditions) {
		return new UseItemSuccessTrigger.Instance(playerPred, class_2073.method_8969(json.get("item")), class_2090.method_9021(json.get("location")));
	}

	public void trigger(class_3222 player, class_1799 stack, class_3218 world, double x, double y, double z) {
		method_22510(player, instance -> instance.test(stack, world, x, y, z));
	}

	public static class Instance extends class_195 {
		private final class_2073 item;
		private final class_2090 location;

		public Instance(class_5258 playerPred, class_2073 count, class_2090 indexPos) {
			super(ID, playerPred);
			this.item = count;
			this.location = indexPos;
		}

		@NotNull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_1799 stack, class_3218 world, double x, double y, double z) {
			return this.item.method_8970(stack) && this.location.method_9018(world, x, y, z);
		}

		public class_2073 getItem() {
			return this.item;
		}

		@Override
		public JsonObject method_807(class_5267 serializationContext) {
			JsonObject json = super.method_807(serializationContext);
			if (item != class_2073.field_9640) {
				json.add("item", item.method_8971());
			}
			if (location != class_2090.field_9685) {
				json.add("location", location.method_9019());
			}
			return json;
		}

		public class_2090 getLocation() {
			return this.location;
		}
	}
}
