/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.network.serverbound;

import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.network.BotaniaPacket;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public record IndexKeybindRequestPacket(class_1799 stack) implements BotaniaPacket {
	public static final class_2960 ID = prefix("idx");

	@Override
	public void encode(class_2540 buf) {
		buf.method_10793(stack());
	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	public static IndexKeybindRequestPacket decode(class_2540 buf) {
		return new IndexKeybindRequestPacket(buf.method_10819());
	}

	public void handle(MinecraftServer server, class_3222 player) {
		var stack = this.stack();
		server.execute(() -> {
			if (player.method_7325()) {
				return;
			}

			for (CorporeaIndexBlockEntity index : CorporeaIndexBlockEntity.getNearbyValidIndexes(player)) {
				index.performPlayerRequest(player, CorporeaHelper.instance().createMatcher(stack, true), stack.method_7947());
			}
		});
	}
}
