/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.network.clientbound;

import vazkii.botania.client.core.SkyblockWorldInfo;
import vazkii.botania.network.BotaniaPacket;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class GogWorldPacket implements BotaniaPacket {
	public static final GogWorldPacket INSTANCE = new GogWorldPacket();
	public static final class_2960 ID = prefix("gog");

	@Override
	public void encode(class_2540 buf) {}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	public static GogWorldPacket decode(class_2540 buf) {
		return INSTANCE;
	}

	public static class Handler {
		public static void handle(GogWorldPacket packet) {
			class_310.method_1551().execute(() -> {
				if (class_310.method_1551().field_1687.method_28104() instanceof SkyblockWorldInfo skyblockInfo) {
					skyblockInfo.markGardenOfGlass();
				}
			});
		}
	}
}
