/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin.client;

import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_638;

@Mixin(class_1140.class)
public class SoundEngineMixin {
	@Unique
	@Nullable
	private class_1113 tmpSound;

	@Unique
	private static Set<class_1113> mutedSounds;

	// calculateVolume(float, SoundSource) can be called from two different places, capture in each of them

	@Inject(at = @At("HEAD"), method = "calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F")
	private void captureSound(class_1113 sound, CallbackInfoReturnable<Float> cir) {
		tmpSound = sound;
	}

	@Inject(at = @At("HEAD"), method = "play")
	private void captureSound2(class_1113 sound, CallbackInfo ci) {
		tmpSound = sound;
	}

	@Unique
	private static boolean shouldSilence(class_1113 sound) {
		return sound.method_4774() != class_3419.field_15246
				&& sound.method_4774() != class_3419.field_15253
				&& sound.method_4774() != class_3419.field_15247
				&& sound.method_4774() != class_3419.field_15256;
	}

	@ModifyArg(index = 0, at = @At(value = "INVOKE", target = "Lnet/minecraft/util/Mth;clamp(FFF)F"), method = "calculateVolume(FLnet/minecraft/sounds/SoundSource;)F")
	private float bergamuateAttenuate(float volume) {
		class_1113 sound = this.tmpSound;

		if (sound != null && shouldSilence(sound)) {
			// We halve the volume for each flower (see return below)
			// halving 8 times already brings the multiplier to near zero, so no
			// need to keep going if we've seen more than 8.
			var level = class_310.method_1551().field_1687;
			Pair<Integer, BergamuteBlockEntity> countAndBerg = level == null
					? Pair.of(0, null)
					: BergamuteBlockEntity.getBergamutesNearby(level, sound.method_4784(), sound.method_4779(), sound.method_4778(), 8);
			int count = countAndBerg.getFirst();
			if (count > 0) {
				if (mutedSounds == null) {
					mutedSounds = Collections.newSetFromMap(new WeakHashMap<>());
				}
				if (mutedSounds.add(sound) && Math.random() < 0.5) {
					BergamuteBlockEntity.particle(countAndBerg.getSecond());
				}

				// If the multiplier here is adjusted, also adjust the count constant passed to getBergamutesNearby
				return volume * (float) Math.pow(0.5, count);
			}
		}
		return volume;
	}

	@Inject(at = @At("RETURN"), method = "calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F")
	private void clearSound(class_1113 sound, CallbackInfoReturnable<Float> cir) {
		tmpSound = null;
	}

	@Inject(at = @At("RETURN"), method = "play")
	private void clearSound2(class_1113 sound, CallbackInfo ci) {
		tmpSound = null;
	}
}
