/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_2338;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.brew.effect.BloodthirstMobEffect;

@Mixin(class_1317.class)
public class SpawnPlacementsMixin {
	// This injection is kind of scuffed:
	// In vanilla code, canSpawnEntity calls a per-entity predicate to determine spawnability.
	// Many (but not all) hostile mobs register their own canSpawn predicates or fall back to MonsterEntity::canSpawnInLightLevel,
	// which ordinarily should be jumped over under Bloodthirst.
	// However, certain mobs (e.g. slimes) use the predicate for actual logic (e.g. slimechunks),
	// and we jump over that in Bloodthirst as well.
	@Inject(at = @At("RETURN"), cancellable = true, method = "checkSpawnRules")
	private static <T extends class_1297> void bloodthirstOverride(class_1299<T> type, class_5425 world, class_3730 reason, class_2338 position, class_5819 random, CallbackInfoReturnable<Boolean> cir) {
		if (reason == class_3730.field_16459 && BloodthirstMobEffect.overrideSpawn(world, position, type.method_5891())) {
			cir.setReturnValue(true);
		}
	}

}
