/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.block.block_entity.LifeImbuerBlockEntity;

@Mixin(class_1917.class)
public class BaseSpawnerMixin {
	@Inject(at = @At("RETURN"), method = "isNearPlayer", cancellable = true)
	private void injectNearPlayer(class_1937 level, class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
		// If vanilla is out of range, then we do our work
		if (!cir.getReturnValueZ()) {
			LifeImbuerBlockEntity.onSpawnerNearPlayer(level, pos, cir);
		}
	}
}
