/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.data;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7784;
import net.minecraft.class_7877;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import vazkii.botania.data.*;
import vazkii.botania.data.recipes.*;

import static vazkii.botania.common.BotaniaDamageTypes.*;

public class FabricDatagenInitializer implements DataGeneratorEntrypoint {
	@Override
	public void onInitializeDataGenerator(FabricDataGenerator generator) {
		if (System.getProperty("botania.xplat_datagen") != null) {
			configureXplatDatagen(generator.createPack());
		} else {
			configureFabricDatagen(generator.createPack());
		}
	}

	private static void configureFabricDatagen(FabricDataGenerator.Pack pack) {
		pack.method_46566((class_7784 output) -> new FabricBlockLootProvider(output));
		var blockTagProvider = pack.addProvider(FabricBlockTagProvider::new);
		pack.addProvider((output, registriesFuture) -> new FabricItemTagProvider(output, registriesFuture, blockTagProvider.method_49662()));
		pack.method_46566((class_7784 output) -> new FabricRecipeProvider(output));
		pack.addProvider(FabricBiomeTagProvider::new);
	}

	private static void configureXplatDatagen(FabricDataGenerator.Pack pack) {
		pack.method_46566((class_7784 output) -> new BlockLootProvider(output));
		pack.method_46566((class_7784 output) -> new LooniumStructureLootProvider(output));
		pack.method_46566((class_7784 output) -> new LooniumStructureConfigurationProvider(output));
		pack.addProvider(LooniumEquipmentLootProvider::new);
		BlockTagProvider blockTagProvider = pack.addProvider(BlockTagProvider::new);
		pack.addProvider((output, registriesFuture) -> new ItemTagProvider(output, registriesFuture, blockTagProvider.method_49662()));
		pack.addProvider(EntityTagProvider::new);
		pack.addProvider(BannerPatternTagsProvider::new);
		pack.addProvider(BiomeTagProvider::new);
		pack.addProvider(BotaniaDynamicRegistryProvider::new);
		pack.addProvider(DamageTypeTagProvider::new);
		pack.method_46566((class_7784 output) -> new StonecuttingProvider(output));
		pack.method_46566((class_7784 output) -> new CraftingRecipeProvider(output));
		pack.method_46566((class_7784 output) -> new SmeltingProvider(output));
		pack.method_46566((class_7784 output) -> new ElvenTradeProvider(output));
		pack.method_46566((class_7784 output) -> new ManaInfusionProvider(output));
		pack.method_46566((class_7784 output) -> new PureDaisyProvider(output));
		pack.method_46566((class_7784 output) -> new BrewProvider(output));
		pack.method_46566((class_7784 output) -> new PetalApothecaryProvider(output));
		pack.method_46566((class_7784 output) -> new RunicAltarProvider(output));
		pack.method_46566((class_7784 output) -> new TerrestrialAgglomerationProvider(output));
		pack.method_46566((class_7784 output) -> new OrechidProvider(output));
		pack.method_46566((class_7784 output) -> new BlockstateProvider(output));
		pack.method_46566((class_7784 output) -> new FloatingFlowerModelProvider(output));
		pack.method_46566((class_7784 output) -> new ItemModelProvider(output));
		pack.method_46566((class_7784 output) -> new PottedPlantModelProvider(output));
		pack.addProvider(AdvancementProvider::create);
	}

	@Override
	public void buildRegistry(class_7877 builder) {
		builder.method_46777(class_7924.field_42534, FabricDatagenInitializer::damageTypeBC);
	}

	protected static void damageTypeBC(class_7891<class_8110> context) {
		context.method_46838(RELIC_DAMAGE, RELIC);
		context.method_46838(PLAYER_ATTACK_ARMOR_PIERCING, PLAYER_AP);
		context.method_46838(KEY_EXPLOSION, KEY);
	}
}
