/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaSpreader;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_238;

public class TripwireLens extends Lens {

	@Override
	public boolean allowBurstShooting(class_1799 stack, ManaSpreader spreader, boolean redstone) {
		ManaBurst burst = spreader.runBurstSimulation();
		return burst.hasTripped();
	}

	@Override
	public void updateBurst(ManaBurst burst, class_1799 stack) {
		class_1297 entity = burst.entity();
		if (burst.isFake()) {
			if (entity.method_37908().field_9236) {
				return;
			}

			class_238 axis = new class_238(entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.field_6038, entity.field_5971, entity.field_5989).method_1014(0.25);
			List<class_1309> entities = entity.method_37908().method_18467(class_1309.class, axis);
			if (!entities.isEmpty()) {
				burst.setTripped(true);
			}
		}

	}

}
