/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class MagnetizingLens extends Lens {

	@Override
	public void updateBurst(ManaBurst burst, class_1799 stack) {
		class_1297 entity = burst.entity();
		class_2338 basePos = entity.method_24515();
		boolean magnetized = burst.getMagnetizedPos() != null;
		int range = 3;

		class_2338 source = burst.getBurstSourceBlockPos();
		final boolean sourceless = source.equals(ManaBurst.NO_SOURCE);

		Predicate<class_2338> predicate = pos -> {
			var receiver = XplatAbstractions.INSTANCE.findManaReceiver(entity.method_37908(), pos, null);
			return receiver != null
					&& (sourceless || pos.method_10262(source) > 9)
					&& receiver.canReceiveManaFromBursts()
					&& !receiver.isFull();
		};

		// todo: clean this logic up
		class_2338 target = null;
		if (magnetized) {
			target = burst.getMagnetizedPos();
			if (!predicate.test(target)) {
				target = null;
				burst.setMagnetizePos(null);
				magnetized = false;
			}
		}

		if (!magnetized) {
			for (class_2338 pos : class_2338.method_10097(basePos.method_10069(-range, -range, -range),
					basePos.method_10069(range, range, range))) {
				target = pos;
				if (predicate.test(target)) {
					break;
				}
				target = null;
			}
		}

		if (target == null) {
			return;
		}

		class_243 burstVec = entity.method_19538();
		class_243 tileVec = class_243.method_24953(target).method_1031(0, -0.1, 0);
		class_243 motionVec = entity.method_18798();

		class_243 normalMotionVec = motionVec.method_1029();
		class_243 magnetVec = tileVec.method_1020(burstVec).method_1029();
		class_243 differenceVec = normalMotionVec.method_1020(magnetVec).method_1021(motionVec.method_1033() * 0.1);

		class_243 finalMotionVec = motionVec.method_1020(differenceVec);
		if (!magnetized) {
			finalMotionVec = finalMotionVec.method_1021(0.75);
			burst.setMagnetizePos(target.method_10062());
		}

		entity.method_18799(finalMotionVec);
	}

}
