/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_8103;
import org.apache.commons.lang3.mutable.MutableFloat;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.handler.BotaniaSounds;

public class CloakOfBalanceItem extends CloakOfVirtueItem {

	private static final class_2960 texture = new class_2960(ResourcesLib.MODEL_BALANCE_CLOAK);
	private static final class_2960 textureGlow = new class_2960(ResourcesLib.MODEL_BALANCE_CLOAK_GLOW);

	public CloakOfBalanceItem(class_1793 props) {
		super(props);
	}

	@Override
	protected boolean effectOnDamage(class_1282 src, MutableFloat amount, class_1657 player, class_1799 stack) {
		if (!src.method_48789(class_8103.field_42248)) {
			amount.setValue(amount.getValue() / 2);

			if (src.method_5529() != null) {
				src.method_5529().method_5643(player.method_48923().method_48815(player, player), amount.getValue());
			}

			if (amount.getValue() > player.method_6032()) {
				amount.setValue(player.method_6032() - 1);
			}

			player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.holyCloak, class_3419.field_15248, 1F, 1F);
			for (int i = 0; i < 30; i++) {
				double x = player.method_23317() + Math.random() * player.method_17681() * 2 - player.method_17681();
				double y = player.method_23318() + Math.random() * player.method_17682();
				double z = player.method_23321() + Math.random() * player.method_17681() * 2 - player.method_17681();
				boolean green = Math.random() > 0.5;
				float g = green ? 1F : 0.3F;
				float b = green ? 0.3F : 1F;
				SparkleParticleData data = SparkleParticleData.sparkle(0.8F + (float) Math.random() * 0.4F, 0.3F, g, b, 3);
				player.method_37908().method_8406(data, x, y, z, 0, 0, 0);
			}
			return true;
		}

		return false;
	}

	@Override
	class_2960 getCloakTexture() {
		return texture;
	}

	@Override
	class_2960 getCloakGlowTexture() {
		return textureGlow;
	}

}
