/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import com.google.common.base.Suppliers;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class ElementiumArmorItem extends ManasteelArmorItem {

	public ElementiumArmorItem(class_8051 type, class_1793 props) {
		super(type, BotaniaAPI.instance().getElementiumArmorMaterial(), props);
	}

	@Override
	public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
		return ResourcesLib.MODEL_ELEMENTIUM_NEW;
	}

	private static final Supplier<class_1799[]> armorSet = Suppliers.memoize(() -> new class_1799[] {
			new class_1799(BotaniaItems.elementiumHelm),
			new class_1799(BotaniaItems.elementiumChest),
			new class_1799(BotaniaItems.elementiumLegs),
			new class_1799(BotaniaItems.elementiumBoots)
	});

	@Override
	public class_1799[] getArmorSetStacks() {
		return armorSet.get();
	}

	@Override
	public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
		if (player == null) {
			return false;
		}

		class_1799 stack = player.method_6118(slot);
		if (stack.method_7960()) {
			return false;
		}

		return switch (slot) {
			case field_6169 -> stack.method_31574(BotaniaItems.elementiumHelm);
			case field_6174 -> stack.method_31574(BotaniaItems.elementiumChest);
			case field_6172 -> stack.method_31574(BotaniaItems.elementiumLegs);
			case field_6166 -> stack.method_31574(BotaniaItems.elementiumBoots);
			default -> false;
		};

	}

	@Override
	public class_5250 getArmorSetName() {
		return class_2561.method_43471("botania.armorset.elementium.name");
	}

	@Override
	public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
		super.addArmorSetDescription(stack, list);
		list.add(class_2561.method_43471("botania.armorset.elementium.desc").method_27692(class_124.field_1080));
	}

}
