/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.internal_caps;

import net.minecraft.class_2487;
import vazkii.botania.common.block.SpectralRailBlock;

public class SpectralRailComponent extends SerializableComponent {
	public int floatTicks = 0;

	@Override
	public void readFromNbt(class_2487 tag) {
		floatTicks = tag.method_10550(SpectralRailBlock.TAG_FLOAT_TICKS);
	}

	@Override
	public void writeToNbt(class_2487 tag) {
		tag.method_10569(SpectralRailBlock.TAG_FLOAT_TICKS, floatTicks);
	}
}
