/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.internal_caps;

import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class LooniumComponent extends SerializableComponent {
	protected static final String TAG_TO_DROP = "toDrop";
	protected static final String TAG_OVERRIDE_DROP = "overrideDrop";
	protected static final String TAG_SLOW_DESPAWN = "slowDespawn";
	private class_1799 toDrop = class_1799.field_8037;
	private boolean overrideDrop;
	private boolean slowDespawn;

	public class_1799 getDrop() {
		return toDrop;
	}

	public void setDrop(class_1799 stack) {
		this.toDrop = stack;
	}

	public boolean isOverrideDrop() {
		return overrideDrop;
	}

	public void setOverrideDrop(boolean overrideDrop) {
		this.overrideDrop = overrideDrop;
	}

	public boolean isSlowDespawn() {
		return slowDespawn;
	}

	public void setSlowDespawn(boolean slowDespawn) {
		this.slowDespawn = slowDespawn;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		return obj instanceof LooniumComponent component && class_1799.method_7973(component.toDrop, toDrop)
				&& component.overrideDrop == overrideDrop && component.slowDespawn == slowDespawn;
	}

	@Override
	public int hashCode() {
		return Objects.hash(toDrop.hashCode(), overrideDrop, slowDespawn);
	}

	@Override
	public void readFromNbt(class_2487 tag) {
		if (tag.method_10545(TAG_TO_DROP)) {
			setDrop(class_1799.method_7915(tag.method_10562(TAG_TO_DROP)));
		} else {
			setDrop(class_1799.field_8037);
		}
		if (tag.method_10545(TAG_OVERRIDE_DROP)) {
			setOverrideDrop(tag.method_10577(TAG_OVERRIDE_DROP));
		}
		if (tag.method_10545(TAG_SLOW_DESPAWN)) {
			setSlowDespawn(tag.method_10577(TAG_SLOW_DESPAWN));
		}
	}

	@Override
	public void writeToNbt(class_2487 tag) {
		if (isOverrideDrop()) {
			if (!getDrop().method_7960()) {
				tag.method_10566(TAG_TO_DROP, getDrop().method_7953(new class_2487()));
			}
			tag.method_10556(TAG_OVERRIDE_DROP, true);
		}
		if (isSlowDespawn()) {
			tag.method_10556(TAG_SLOW_DESPAWN, true);
		}
	}
}
