package vazkii.botania.common.helper;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import vazkii.botania.api.item.BlockProvider;

public class BlockProviderHelper {
	public static BlockProvider asBlockProvider(final class_1799 stack) {
		return new ItemStackBlockProvider(stack);
	}

	public static BlockProvider asInfiniteBlockProvider(final class_1799 stack) {
		return new InfiniteItemStackBlockProvider(stack);
	}

	private record ItemStackBlockProvider(class_1799 stack) implements BlockProvider {

		@Override
		public boolean provideBlock(class_1657 player, class_1799 requester, class_2248 block, boolean doIt) {
			final boolean canDo = !stack.method_7960() && stack.method_31574(block.method_8389());
			if (canDo && doIt && !player.method_31549().field_7477) {
				stack.method_7934(1);
			}
			return canDo;
		}

		@Override
		public int getBlockCount(class_1657 player, class_1799 requester, class_2248 block) {
			if (!stack.method_31574(block.method_8389())) {
				return 0;
			}
			return player.method_31549().field_7477 ? -1 : stack.method_7947();
		}
	}

	private record InfiniteItemStackBlockProvider(class_1799 stack) implements BlockProvider {

		private InfiniteItemStackBlockProvider(class_1799 stack) {
			this.stack = stack.method_7972();
		}

		@Override
		public boolean provideBlock(class_1657 player, class_1799 requester, class_2248 block, boolean doIt) {
			return stack.method_31574(block.method_8389());
		}

		@Override
		public int getBlockCount(class_1657 player, class_1799 requester, class_2248 block) {
			return stack.method_31574(block.method_8389()) ? -1 : 0;
		}
	}
}
