/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.handler;

import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.elementium.ElementiumHelmItem;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1329;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5425;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class PixieHandler {

	private PixieHandler() {}

	public static final class_1320 PIXIE_SPAWN_CHANCE = new class_1329("attribute.name.botania.pixieSpawnChance", 0, 0, 1);
	private static final Map<class_1304, UUID> DEFAULT_MODIFIER_UUIDS = class_156.method_654(new EnumMap<>(class_1304.class), m -> {
		m.put(class_1304.field_6169, UUID.fromString("3c1f559c-9ec4-412d-ada0-dbf3e714088e"));
		m.put(class_1304.field_6174, UUID.fromString("9631121c-16f0-4ed4-ba0a-0e7a063cb71c"));
		m.put(class_1304.field_6172, UUID.fromString("a87117a1-ac15-4b17-9fd5-e98d5fe31ff1"));
		m.put(class_1304.field_6166, UUID.fromString("ff67d38a-c5be-4a00-90ed-76bb12c45523"));
		m.put(class_1304.field_6173, UUID.fromString("995829fa-94c0-41bd-b046-0468c509a488"));
		m.put(class_1304.field_6171, UUID.fromString("34f62de8-f652-4fe7-899f-a8fc938c4940"));
	});

	private static final List<Supplier<class_1293>> effectSuppliers = List.of(
			() -> new class_1293(class_1294.field_5919, 40, 0),
			() -> new class_1293(class_1294.field_5920, 50, 0),
			() -> new class_1293(class_1294.field_5909, 40, 0),
			() -> new class_1293(class_1294.field_5911, 40, 0)
	);

	public static void registerAttribute(BiConsumer<class_1320, class_2960> r) {
		r.accept(PIXIE_SPAWN_CHANCE, prefix("pixie_spawn_chance"));
	}

	public static class_1322 makeModifier(class_1304 slot, String name, double amount) {
		return new class_1322(DEFAULT_MODIFIER_UUIDS.get(slot), name, amount, class_1322.class_1323.field_6328);
	}

	public static void onDamageTaken(class_1657 player, class_1282 source) {
		if (!player.method_37908().field_9236 && source.method_5529() instanceof class_1309 livingSource) {
			// Sometimes the player doesn't have the attribute, not sure why.
			// Could be badly-written mixins on Fabric.
			double chance = player.method_6127().method_27306(PIXIE_SPAWN_CHANCE)
					? player.method_26825(PIXIE_SPAWN_CHANCE) : 0;
			class_1799 sword = PlayerHelper.getFirstHeldItem(player, s -> s.method_31574(BotaniaItems.elementiumSword));

			if (Math.random() < chance) {
				PixieEntity pixie = new PixieEntity(player.method_37908());
				pixie.method_5814(player.method_23317(), player.method_23318() + 2, player.method_23321());

				if (((ElementiumHelmItem) BotaniaItems.elementiumHelm).hasArmorSet(player)) {
					pixie.setApplyPotionEffect(effectSuppliers.get(player.method_37908().field_9229.method_43048(effectSuppliers.size())).get());
				}

				float dmg = 4;
				if (!sword.method_7960()) {
					dmg += 2;
				}

				pixie.setProps(livingSource, player, 0, dmg);
				pixie.method_5943((class_5425) player.method_37908(), player.method_37908().method_8404(pixie.method_24515()),
						class_3730.field_16467, null, null);
				player.method_37908().method_8649(pixie);
			}
		}
	}
}
