package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

// Serializer for dynamic recipes that don't have a json/network representation
// The recipe type fully identifies the recipe
public class NoOpRecipeSerializer<T extends class_1860<?>> implements class_1865<T> {
	private final Function<class_2960, T> constructor;

	public NoOpRecipeSerializer(Function<class_2960, T> constructor) {
		this.constructor = constructor;
	}

	@Override
	public T method_8121(class_2960 recipeId, JsonObject serializedRecipe) {
		return this.constructor.apply(recipeId);
	}

	@Override
	public T method_8122(class_2960 recipeId, class_2540 buffer) {
		return this.constructor.apply(recipeId);
	}

	@Override
	public void method_8124(class_2540 buffer, T recipe) {}
}
