/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaBlasterItem;

public class ManaBlasterClipRecipe extends class_1852 {
	public static final NoOpRecipeSerializer<ManaBlasterClipRecipe> SERIALIZER = new NoOpRecipeSerializer<>(ManaBlasterClipRecipe::new);

	public ManaBlasterClipRecipe(class_2960 id) {
		super(id, class_7710.field_40250);
	}

	@Override
	public boolean matches(@NotNull class_8566 inv, @NotNull class_1937 world) {
		boolean foundGun = false;
		boolean foundClip = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof ManaBlasterItem
						&& !ManaBlasterItem.hasClip(stack) && !foundGun) {
					foundGun = true;
				} else if (stack.method_31574(BotaniaItems.clip) && !foundClip) {
					foundClip = true;
				} else {
					return false; // Found an invalid item, breaking the recipe
				}
			}
		}

		return foundGun && foundClip;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_8566 inv, @NotNull class_5455 registries) {
		class_1799 gun = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960() && stack.method_7909() instanceof ManaBlasterItem) {
				gun = stack;
			}
		}

		if (gun.method_7960()) {
			return class_1799.field_8037;
		}

		class_1799 lens = ManaBlasterItem.getLens(gun);
		class_1799 gunCopy = gun.method_7972();
		ManaBlasterItem.setLens(gunCopy, class_1799.field_8037);
		ManaBlasterItem.setClip(gunCopy, true);
		ManaBlasterItem.setLensAtPos(gunCopy, lens, 0);
		return gunCopy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
