/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.item.WandOfTheForestItem;

public class ManaEnchanterBlock extends BotaniaBlock implements class_2343 {

	public ManaEnchanterBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(BotaniaStateProperties.ENCHANTER_DIRECTION, class_2350.class_2351.field_11048));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(BotaniaStateProperties.ENCHANTER_DIRECTION);
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new ManaEnchanterBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.ENCHANTER, ManaEnchanterBlockEntity::commonTick);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		ManaEnchanterBlockEntity enchanter = (ManaEnchanterBlockEntity) world.method_8321(pos);
		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960() && stack.method_7909() instanceof WandOfTheForestItem) {
			return class_1269.field_5811;
		}

		boolean stackEnchantable = !stack.method_7960()
				&& !stack.method_31574(class_1802.field_8529)
				&& stack.method_7923()
				&& stack.method_7947() == 1;

		if (enchanter.itemToEnchant.method_7960()) {
			if (stackEnchantable) {
				enchanter.itemToEnchant = stack.method_7972();
				player.method_6122(hand, class_1799.field_8037);
				enchanter.sync();
			} else {
				return class_1269.field_5811;
			}
		} else if (enchanter.stage == ManaEnchanterBlockEntity.State.IDLE) {
			player.method_31548().method_7398(enchanter.itemToEnchant.method_7972());
			enchanter.itemToEnchant = class_1799.field_8037;
			enchanter.sync();
		}

		return class_1269.method_29236(world.method_8608());
	}

	@Override
	public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
		if (!state.method_27852(newState.method_26204())) {
			class_2586 tile = world.method_8321(pos);

			if (tile instanceof ManaEnchanterBlockEntity enchanter) {

				if (!enchanter.itemToEnchant.method_7960()) {
					class_1264.method_5449(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), enchanter.itemToEnchant);
				}
			}

			super.method_9536(state, world, pos, newState, isMoving);
		}
	}
}
