/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2500;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4849;
import net.minecraft.class_4864;
import net.minecraft.class_6088;
import net.minecraft.world.level.block.*;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.mixin.GrowingPlantBodyBlockMixin;
import vazkii.botania.xplat.BotaniaConfig;

public class AgricarnationBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int RANGE = 5;
	private static final int RANGE_MINI = 2;
	private static final int MANA_COST = 5;
	private static final float BONEMEAL_SUCCESS_CHANCE = 0.5f;

	protected AgricarnationBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	public AgricarnationBlockEntity(class_2338 pos, class_2680 state) {
		this(BotaniaFlowerBlocks.AGRICARNATION, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!(method_10997() instanceof class_3218 serverLevel)) {
			return;
		}

		if (ticksExisted % 200 == 0) {
			sync();
		}

		if (ticksExisted % 6 == 0 && redstoneSignal == 0) {
			int range = getRange();
			int x = getEffectivePos().method_10263() + serverLevel.field_9229.method_43048(range * 2 + 1) - range;
			int z = getEffectivePos().method_10260() + serverLevel.field_9229.method_43048(range * 2 + 1) - range;

			for (int i = 4; i > -2; i--) {
				int y = getEffectivePos().method_10264() + i;
				class_2338 pos = new class_2338(x, y, z);
				class_2680 state = serverLevel.method_8320(pos);
				if (state.method_26215()) {
					continue;
				}

				class_2248 block = state.method_26204();
				if (block instanceof class_4864) {
					var headPos = ((GrowingPlantBodyBlockMixin) block).botania_getHeadPos(serverLevel, pos, block);
					if (headPos.isPresent()) {
						pos = headPos.get();
					}
				}

				if (isPlant(serverLevel, pos, state, block) && getMana() > MANA_COST) {
					addMana(-MANA_COST);
					if (state.method_26164(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL)
							&& block instanceof class_2256 bonemealableBlock
							&& bonemealableBlock.method_9651(serverLevel, pos, state, false)) {
						if (serverLevel.field_9229.method_43057() < BONEMEAL_SUCCESS_CHANCE
								&& bonemealableBlock.method_9650(serverLevel, serverLevel.field_9229, pos, state)) {
							bonemealableBlock.method_9652(serverLevel, serverLevel.field_9229, pos, state);
						}
					} else {
						state.method_26199(serverLevel, pos, serverLevel.field_9229);
					}
					if (BotaniaConfig.common().blockBreakParticles()) {
						serverLevel.method_20290(class_6088.field_31148, pos, 6 + serverLevel.field_9229.method_43048(4));
					}
					serverLevel.method_43128(null, x, y, z, BotaniaSounds.agricarnation, class_3419.field_15245, 1F, 0.5F + (float) Math.random() * 0.5F);

					break;
				}
			}
		}
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	/**
	 * @return Whether the agricarnation considers the given block a plant it can grow. By default,
	 *         grass/mycelium/nylium-like spreading blocks are excluded. They can be excplicitly included by being added
	 *         to the AGRICARNATION_GROWTH_CANDIDATE tag. Blocks in AGRICARNATION_GROWTH_EXCLUDED are always excluded.
	 *         Potential included blocks are those that are bonemealable, instance of BushBlock, or in the
	 *         AGRICARNATION_GROWTH_CANDIDATE tag. They are included only if they accept random ticks, or are
	 *         bonemealable and have the AGRICARNATION_APPLY_BONEMEAL tag.
	 */
	private boolean isPlant(class_1937 level, class_2338 pos, class_2680 state, class_2248 block) {
		if (state.method_26164(BotaniaTags.Blocks.AGRICARNATION_GROWTH_EXCLUDED)
				// grass/mycelium/nylium-like spreading blocks are excluded unless tagged otherwise
				|| (block instanceof class_2500 || block instanceof class_4849)
						&& !state.method_26164(BotaniaTags.Blocks.AGRICARNATION_GROWTH_CANDIDATE)) {
			return false;
		}

		boolean couldApplyBonemeal = block instanceof class_2256 bonemealableBlock
				&& bonemealableBlock.method_9651(level, pos, state, level.field_9236);

		boolean isTargetCandidate = couldApplyBonemeal
				|| block instanceof class_2261
				|| state.method_26164(BotaniaTags.Blocks.AGRICARNATION_GROWTH_CANDIDATE);
		boolean acceptsGrowthBoost = state.method_26229()
				|| couldApplyBonemeal && state.method_26164(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL);

		return isTargetCandidate && acceptsGrowthBoost;

	}

	@Override
	public int getColor() {
		return 0x8EF828;
	}

	@Override
	public int getMaxMana() {
		return 200;
	}

	public int getRange() {
		return RANGE;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), getRange());
	}

	public static class Mini extends AgricarnationBlockEntity {
		public Mini(class_2338 pos, class_2680 state) {
			super(BotaniaFlowerBlocks.AGRICARNATION_CHIBI, pos, state);
		}

		@Override
		public int getRange() {
			return RANGE_MINI;
		}
	}

}
