/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.corporea;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.corporea.CorporeaRetainerBlockEntity;

public class CorporeaRetainerBlock extends BotaniaBlock implements class_2343 {

	public CorporeaRetainerBlock(class_4970.class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 fromBlock, class_2338 fromPos, boolean isMoving) {
		boolean power = false;
		for (var direction : class_2350.values()) {
			var neighborPos = pos.method_10093(direction);
			var neighborState = world.method_8320(neighborPos);
			if (!neighborState.method_27852(BotaniaBlocks.corporeaInterceptor)) {
				if (world.method_49808(neighborPos, direction) > 0) {
					power = true;
					break;
				}
			}
		}
		boolean powered = state.method_11654(class_2741.field_12484);

		if (power && !powered) {
			((CorporeaRetainerBlockEntity) world.method_8321(pos)).fulfilRequest();
			world.method_8501(pos, state.method_11657(class_2741.field_12484, true));
		} else if (!power && powered) {
			world.method_8501(pos, state.method_11657(class_2741.field_12484, false));
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return ((CorporeaRetainerBlockEntity) world.method_8321(pos)).getComparatorValue();
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new CorporeaRetainerBlockEntity(pos, state);
	}
}
