/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import ;
import com.mojang.blaze3d.systems.RenderSystem;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.recipe.CustomApothecaryColor;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1785;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_5712;

public class PetalApothecaryBlockEntity extends SimpleInventoryBlockEntity implements PetalApothecary {

	private static final int SET_KEEP_TICKS_EVENT = 0;
	private static final int CRAFT_EFFECT_EVENT = 1;

	private List<class_1799> lastRecipe = null;
	private class_1856 lastReagent = class_1856.field_9017;
	private int recipeKeepTicks = 0;

	public PetalApothecaryBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.ALTAR, pos, state);
	}

	public boolean collideEntityItem(class_1542 item) {
		class_1799 stack = item.method_6983();
		if (field_11863.field_9236 || stack.method_7960() || !item.method_5805()) {
			return false;
		}

		if (getFluid() == State.EMPTY) {
			// XXX: special handling for now since fish buckets don't have fluid cap, may need to be changed later
			if (stack.method_7909() instanceof class_1785 bucketItem && XplatAbstractions.INSTANCE.getBucketFluid(bucketItem) == class_3612.field_15910) {
				setFluid(State.WATER);
				bucketItem.method_7728(null, field_11863, stack, method_11016().method_10084()); // Spawns the fish
				item.method_6979(new class_1799(class_1802.field_8550));
				XplatAbstractions.INSTANCE.itemFlagsComponent(item).apothecarySpawned = true;
				return true;
			}

			if (XplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, class_3612.field_15910)) {
				setFluid(State.WATER);
				XplatAbstractions.INSTANCE.itemFlagsComponent(item).apothecarySpawned = true;
				return true;
			}

			if (XplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, class_3612.field_15908)) {
				setFluid(State.LAVA);
				XplatAbstractions.INSTANCE.itemFlagsComponent(item).apothecarySpawned = true;
				return true;
			}

			return false;
		}

		if (getFluid() == State.LAVA) {
			item.method_5639(100);
			return true;
		}

		Optional<PetalApothecaryRecipe> maybeRecipe = field_11863.method_8433().method_8132(BotaniaRecipeTypes.PETAL_TYPE, getItemHandler(), field_11863);
		if (maybeRecipe.isPresent()) {
			var recipe = maybeRecipe.get();
			if (recipe.getReagent().method_8093(item.method_6983())) {
				saveLastRecipe(recipe.getReagent());
				class_1799 output = recipe.method_8116(getItemHandler(), method_10997().method_30349());
				class_1297 thrower = item.method_24921();

				for (int i = 0; i < inventorySize(); i++) {
					getItemHandler().method_5447(i, class_1799.field_8037);
				}

				EntityHelper.shrinkItem(item);

				class_1542 outputItem = new class_1542(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5, output);
				XplatAbstractions.INSTANCE.itemFlagsComponent(outputItem).apothecarySpawned = true;
				if (thrower instanceof class_1657 player) {
					player.method_51283(recipe, List.of(output));
					output.method_7982(field_11863, player, output.method_7947());
				}
				field_11863.method_8649(outputItem);

				setFluid(State.EMPTY, false);

				field_11863.method_33596(null, class_5712.field_28174, method_11016());
				field_11863.method_8427(method_11016(), method_11010().method_26204(), CRAFT_EFFECT_EVENT, 0);
				return true;
			}
		}

		if (!XplatAbstractions.INSTANCE.isFluidContainer(item)
				&& !XplatAbstractions.INSTANCE.itemFlagsComponent(item).apothecarySpawned) {
			if (!getItemHandler().method_5438(inventorySize() - 1).method_7960()) {
				return false;
			}

			if (lastReagent.method_8093(item.method_6983())) {
				return false;
			}

			for (int i = 0; i < inventorySize(); i++) {
				if (getItemHandler().method_5438(i).method_7960()) {
					getItemHandler().method_5447(i, stack.method_7971(1));
					EntityHelper.syncItem(item);
					field_11863.method_8396(null, field_11867, class_3417.field_14737, class_3419.field_15245, 0.1F, 10F);
					field_11863.method_33596(null, class_5712.field_28733, method_11016());
					clearLastRecipe();
					return true;
				}
			}
		}

		return false;
	}

	@Nullable
	private CustomApothecaryColor getFlowerComponent(class_1799 stack) {
		CustomApothecaryColor c = null;
		if (stack.method_7909() instanceof CustomApothecaryColor color) {
			c = color;
		}
		return c;
	}

	public void saveLastRecipe(class_1856 reagent) {
		lastRecipe = new ArrayList<>();
		for (int i = 0; i < inventorySize(); i++) {
			class_1799 stack = getItemHandler().method_5438(i);
			if (stack.method_7960()) {
				break;
			}
			lastRecipe.add(stack.method_7972());
		}
		lastReagent = reagent;
		recipeKeepTicks = 400;
		field_11863.method_8427(method_11016(), method_11010().method_26204(), SET_KEEP_TICKS_EVENT, 400);
	}

	public void clearLastRecipe() {
		lastRecipe = null;
		lastReagent = class_1856.field_9017;
	}

	public class_1269 trySetLastRecipe(class_1657 player) {
		// lastRecipe is not synced. If we're calling this method we already checked that
		// the apothecary has water and no items, so just optimistically assume
		// success on the client.
		if (player.method_37908().method_8608()) {
			return class_1269.method_29236(true);
		}
		boolean success = InventoryHelper.tryToSetLastRecipe(player, getItemHandler(), lastRecipe, class_3417.field_14737);
		if (success) {
			field_11863.method_33596(null, class_5712.field_28733, method_11016());
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
		return success
				? class_1269.method_29236(false)
				: class_1269.field_5811;
	}

	public boolean isEmpty() {
		for (int i = 0; i < inventorySize(); i++) {
			if (!getItemHandler().method_5438(i).method_7960()) {
				return false;
			}
		}

		return true;
	}

	private void tickRecipeKeep() {
		if (recipeKeepTicks > 0) {
			--recipeKeepTicks;
		} else {
			clearLastRecipe();
		}
	}

	public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, PetalApothecaryBlockEntity self) {
		List<class_1542> items = level.method_18467(class_1542.class, new class_238(
				worldPosition.method_10084()
		));

		boolean didChange = false;
		for (class_1542 item : items) {
			didChange = self.collideEntityItem(item) || didChange;
		}

		if (didChange) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
		}

		self.tickRecipeKeep();
	}

	public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, PetalApothecaryBlockEntity self) {
		for (int i = 0; i < self.inventorySize(); i++) {
			class_1799 stackAt = self.getItemHandler().method_5438(i);
			if (stackAt.method_7960()) {
				break;
			}

			if (Math.random() >= 0.97) {
				CustomApothecaryColor comp = self.getFlowerComponent(stackAt);

				int color = comp == null ? 0x888888 : comp.getParticleColor(stackAt);
				float red = (color >> 16 & 0xFF) / 255F;
				float green = (color >> 8 & 0xFF) / 255F;
				float blue = (color & 0xFF) / 255F;
				if (Math.random() >= 0.75F) {
					level.method_8396(null, worldPosition, class_3417.field_14737, class_3419.field_15245, 0.1F, 10F);
				}
				SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), red, green, blue, 10);
				level.method_8406(data, worldPosition.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, worldPosition.method_10264() + 1.2, worldPosition.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0, 0);
			}
		}

		if (self.getFluid() == State.LAVA) {
			level.method_8406(class_2398.field_11251, worldPosition.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, worldPosition.method_10264() + 1, worldPosition.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0.05, 0);
			if (Math.random() > 0.9) {
				level.method_8406(class_2398.field_11239, worldPosition.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, worldPosition.method_10264() + 1, worldPosition.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0.01, 0);
			}
		}

		self.tickRecipeKeep();
	}

	@Override
	public boolean method_11004(int id, int param) {
		switch (id) {
			case SET_KEEP_TICKS_EVENT:
				recipeKeepTicks = param;
				return true;
			case CRAFT_EFFECT_EVENT: {
				if (field_11863.field_9236) {
					for (int i = 0; i < 25; i++) {
						float red = (float) Math.random();
						float green = (float) Math.random();
						float blue = (float) Math.random();
						SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), red, green, blue, 10);
						field_11863.method_8406(data, field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, field_11867.method_10264() + 1, field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0, 0);
					}
					field_11863.method_8486(field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), BotaniaSounds.altarCraft, class_3419.field_15245, 1F, 1F, false);
				}
				return true;
			}
			default:
				return super.method_11004(id, param);
		}
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(16) {
			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@Override
	public void setFluid(State fluid) {
		setFluid(fluid, true);
	}

	public void setFluid(State fluid, boolean withVibration) {
		if (withVibration) {
			field_11863.method_33596(null, fluid == State.EMPTY ? class_5712.field_28167 : class_5712.field_28166, method_11016());
		}
		field_11863.method_8501(method_11016(), method_11010().method_11657(PetalApothecaryBlock.FLUID, fluid));
	}

	@Override
	public State getFluid() {
		return method_11010().method_11654(PetalApothecaryBlock.FLUID);
	}

	public boolean canAddLastRecipe() {
		return this.isEmpty() && this.getFluid() == State.WATER;
	}

	public static class Hud {
		public static void render(PetalApothecaryBlockEntity altar, class_332 gui, class_310 mc) {
			int xc = mc.method_22683().method_4486() / 2;
			int yc = mc.method_22683().method_4502() / 2;

			float angle = -90;
			int radius = 24;
			int amt = 0;
			for (int i = 0; i < altar.inventorySize(); i++) {
				if (altar.getItemHandler().method_5438(i).method_7960()) {
					break;
				}
				amt++;
			}

			if (amt > 0) {
				float anglePer = 360F / amt;

				Optional<PetalApothecaryRecipe> maybeRecipe = altar.field_11863.method_8433()
						.method_8132(BotaniaRecipeTypes.PETAL_TYPE, altar.getItemHandler(), altar.field_11863);
				maybeRecipe.ifPresent(recipe -> {
					RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
					RenderHelper.drawTexturedModalRect(gui, HUDHandler.manaBar, xc + radius + 9, yc - 8, 0, 8, 22, 15);

					class_1799 stack = recipe.method_8116(altar.getItemHandler(), altar.method_10997().method_30349());
					gui.method_51445(stack, xc + radius + 32, yc - 8);

					var reagents = recipe.getReagent().method_8105();
					class_1799 reagent;
					if (reagents.length == 0) {
						reagent = new class_1799(class_1802.field_8077);
					} else {
						int idx = (int) ((altar.field_11863.method_8510() / 20) % reagents.length);
						reagent = reagents[idx];
					}
					gui.method_51445(reagent, xc + radius + 16, yc + 6);
					gui.method_51433(mc.field_1772, "+", xc + radius + 14, yc + 10, 0xFFFFFF, false);
				});

				for (int i = 0; i < amt; i++) {
					double xPos = xc + Math.cos(angle * Math.PI / 180D) * radius - 8;
					double yPos = yc + Math.sin(angle * Math.PI / 180D) * radius - 8;
					class_4587 pose = RenderSystem.getModelViewStack();
					pose.method_22903();
					pose.method_22904(xPos, yPos, 0);
					RenderSystem.applyModelViewMatrix();
					gui.method_51445(altar.getItemHandler().method_5438(i), 0, 0);
					pose.method_22909();
					RenderSystem.applyModelViewMatrix();

					angle += anglePer;
				}
			}
			if (altar.recipeKeepTicks > 0 && altar.canAddLastRecipe()) {
				String s = class_1074.method_4662("botaniamisc.altarRefill0");
				gui.method_51433(mc.field_1772, s, xc - mc.field_1772.method_1727(s) / 2, yc + 10, 0xFFFFFF, false);
				s = class_1074.method_4662("botaniamisc.altarRefill1");
				gui.method_51433(mc.field_1772, s, xc - mc.field_1772.method_1727(s) / 2, yc + 20, 0xFFFFFF, false);
			}
		}
	}

}
