/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1074;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.HourglassTrigger;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.XplatAbstractions;

public class HoveringHourglassBlockEntity extends ExposedSimpleInventoryBlockEntity implements ManaTrigger, Wandable {
	private static final String TAG_TIME = "time";
	private static final String TAG_TIME_FRACTION = "timeFraction";
	private static final String TAG_FLIP = "flip";
	private static final String TAG_FLIP_TICKS = "flipTicks";
	private static final String TAG_LOCK = "lock";
	private static final String TAG_MOVE = "move";

	private int time = 0;
	public float timeFraction = 0F;
	public float lastFraction = 0;
	public boolean flip = false;
	public int flipTicks = 0;
	public boolean lock = false;
	public boolean move = true;

	public HoveringHourglassBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.HOURGLASS, pos, state);
	}

	private boolean isDust() {
		class_1799 stack = getItemHandler().method_5438(0);
		return !stack.method_7960() && stack.method_31574(BotaniaItems.manaPowder);
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, HoveringHourglassBlockEntity self) {
		int totalTime = self.getTotalTime();
		boolean dust = self.isDust();

		if (totalTime > 0 || dust) {
			if (self.move && !dust) {
				self.time++;
			}

			if (self.time >= totalTime) {
				self.time = 0;
				self.flip = !self.flip;
				self.flipTicks = 4;
				if (!level.field_9236) {
					level.method_8652(worldPosition, state.method_11657(class_2741.field_12484, true), class_2248.field_31027);
					level.method_39279(worldPosition, state.method_26204(), 4);
				}

				for (class_2350 facing : class_2350.values()) {
					class_2338 pos = worldPosition.method_10093(facing);
					var trigger = XplatAbstractions.INSTANCE.findHourglassTrigger(level, pos,
							level.method_8320(pos), level.method_8321(pos));
					if (trigger != null) {
						trigger.onTriggeredByHourglass(self);
					}
				}
			}

			self.lastFraction = self.timeFraction;
			self.timeFraction = (float) self.time / (float) totalTime;
		} else {
			self.time = 0;
			self.lastFraction = 0F;
			self.timeFraction = 0F;
		}

		if (self.flipTicks > 0) {
			self.flipTicks--;
		}
	}

	@Override
	public void onBurstCollision(ManaBurst burst) {
		if (!field_11863.field_9236 && !burst.isFake()) {
			if (isDust()) {
				time++;
			} else {
				move = !move;
			}
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	public int getTotalTime() {
		class_1799 stack = getItemHandler().method_5438(0);
		if (stack.method_7960()) {
			return 0;
		}

		return getStackItemTime(stack) * stack.method_7947();
	}

	public static int getStackItemTime(class_1799 stack) {
		if (stack.method_7960()) {
			return 0;
		}
		if (stack.method_31574(class_2246.field_10102.method_8389())) {
			return 20;
		}
		if (stack.method_31574(class_2246.field_10534.method_8389())) {
			return 200;
		}
		if (stack.method_31574(class_2246.field_10114.method_8389())) {
			return 1200;
		}
		if (stack.method_31574(BotaniaItems.manaPowder)) {
			return 1;
		}
		return 0;
	}

	public int getColor() {
		class_1799 stack = getItemHandler().method_5438(0);
		if (stack.method_7960()) {
			return 0;
		}
		if (stack.method_31574(class_2246.field_10102.method_8389())) {
			return 0xFFEC49;
		}
		if (stack.method_31574(class_2246.field_10534.method_8389())) {
			return 0xE95800;
		}
		if (stack.method_31574(class_2246.field_10114.method_8389())) {
			return 0x5A412f;
		}
		if (stack.method_31574(BotaniaItems.manaPowder)) {
			return 0x03abff;
		}

		return 0;
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1) {
			@Override
			public boolean method_5437(int index, class_1799 stack) {
				return !stack.method_7960() && (stack.method_31574(class_2246.field_10102.method_8389())
						|| stack.method_31574(class_2246.field_10534.method_8389())
						|| stack.method_31574(class_2246.field_10114.method_8389())
						|| stack.method_31574(BotaniaItems.manaPowder));
			}
		};
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			time = 0;
			timeFraction = 0F;
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(HoveringHourglassBlockEntity.this);
		}
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);
		tag.method_10569(TAG_TIME, time);
		tag.method_10548(TAG_TIME_FRACTION, timeFraction);
		tag.method_10556(TAG_FLIP, flip);
		tag.method_10569(TAG_FLIP_TICKS, flipTicks);
		tag.method_10556(TAG_MOVE, move);
		tag.method_10556(TAG_LOCK, lock);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);
		time = tag.method_10550(TAG_TIME);
		timeFraction = tag.method_10583(TAG_TIME_FRACTION);
		flip = tag.method_10577(TAG_FLIP);
		flipTicks = tag.method_10550(TAG_FLIP_TICKS);
		move = tag.method_10577(TAG_MOVE);
		lock = tag.method_10577(TAG_LOCK);
	}

	public static class WandHud implements WandHUD {
		private final HoveringHourglassBlockEntity hourglass;

		public WandHud(HoveringHourglassBlockEntity hourglass) {
			this.hourglass = hourglass;
		}

		@Override
		public void renderHUD(class_332 gui, class_310 mc) {
			class_1799 stack = hourglass.getItemHandler().method_5438(0);
			if (!stack.method_7960()) {
				int x = mc.method_22683().method_4486() / 2 + 8;
				int y = mc.method_22683().method_4502() / 2 - 10;

				String first, second;
				if (hourglass.isDust()) {
					first = Integer.toString(hourglass.time);
					second = Integer.toString(hourglass.getTotalTime());
				} else {
					first = class_3544.method_15439(hourglass.time);
					second = class_3544.method_15439(hourglass.getTotalTime());
				}
				String timer = String.format("%s / %s", first, second);

				String status = hourglass.lock ? "locked" : "";
				if (!hourglass.move) {
					status = status.isEmpty() ? "stopped" : "lockedStopped";
				}
				if (!status.isEmpty()) {
					status = class_1074.method_4662("botaniamisc." + status);
				}

				int textWidth = Math.max(mc.field_1772.method_1727(timer), mc.field_1772.method_1727(status));

				RenderHelper.renderHUDBox(gui, x, y, x + textWidth + 24, y + 22);

				gui.method_51445(stack, x + 2, y + 3);
				gui.method_51431(mc.field_1772, stack, x + 2, y + 3);

				gui.method_25303(mc.field_1772, timer, x + 22, y + 2, hourglass.getColor());
				if (!status.isEmpty()) {
					gui.method_25303(mc.field_1772, status, x + 22, y + 12, hourglass.getColor());
				}
			}
		}
	}

	@Override
	public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
		this.lock = !this.lock;
		if (!method_10997().field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
		return true;
	}
}
