/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class BifrostBlockEntity extends BotaniaBlockEntity {
	private static final String TAG_TICKS = "ticks";

	public int ticks = 0;

	public BifrostBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.BIFROST, pos, state);
	}

	public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, BifrostBlockEntity self) {
		if (self.ticks <= 0) {
			level.method_8650(worldPosition, false);
		} else {
			self.ticks--;
		}
	}

	@Override
	public void method_11007(class_2487 tag) {
		super.method_11007(tag);
		tag.method_10569(TAG_TICKS, ticks);
	}

	@Override
	public void method_11014(@NotNull class_2487 tag) {
		super.method_11014(tag);
		ticks = tag.method_10550(TAG_TICKS);
	}

}
