/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import com.google.common.base.Preconditions;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_6088;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.internal_caps.SpectralRailComponent;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

public class SpectralRailBlock extends class_2241 {

	public static final String TAG_FLOAT_TICKS = "botania:float_ticks";

	public SpectralRailBlock(class_2251 builder) {
		super(true, builder);
		method_9590(method_9564().method_11657(class_2741.field_12542, class_2768.field_12665));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2741.field_12542, field_27096);
	}

	private void updateFloating(class_1688 cart) {
		cart.method_37908().method_16107().method_15396("cartFloating");
		SpectralRailComponent persistentData = XplatAbstractions.INSTANCE.ghostRailComponent(cart);
		int floatTicks = persistentData.floatTicks;
		Preconditions.checkState(floatTicks > 0);

		class_2338 entPos = cart.method_24515();
		class_2680 state = cart.method_37908().method_8320(entPos);
		boolean air = state.method_26215();

		if (state.method_26164(BotaniaTags.Blocks.GHOST_RAIL_BARRIER)
				|| (!state.method_27852(BotaniaBlocks.ghostRail) && state.method_26164(class_3481.field_15463))) {
			cart.method_37908().method_20290(class_6088.field_31146, entPos, 0);
			persistentData.floatTicks = 0;
		} else {
			class_2338 down = entPos.method_10074();
			class_2680 stateBelow = cart.method_37908().method_8320(down);
			boolean airBelow = stateBelow.method_26215();
			if (air && airBelow || !air && !airBelow) {
				cart.field_5960 = true;
			}
			cart.method_18800(cart.method_18798().method_10216() * 1.4, 0.2, cart.method_18798().method_10215() * 1.4);
			persistentData.floatTicks--;
			cart.method_37908().method_20290(class_6088.field_31143, entPos, 0);
		}

		cart.method_37908().method_16107().method_15407();
	}

	@SoftImplement("IForgeBaseRailBlock")
	public void onMinecartPass(class_2680 state, class_1937 world, class_2338 pos, class_1688 cart) {
		if (!world.field_9236) {
			XplatAbstractions.INSTANCE.ghostRailComponent(cart).floatTicks = 20;
			updateFloating(cart);
		}
	}

	public void tickCart(class_1688 c) {
		if (c.method_37908().field_9236 || c.method_31481()) {
			return;
		}

		SpectralRailComponent persistentData = XplatAbstractions.INSTANCE.ghostRailComponent(c);
		if (!c.method_5805() || persistentData.floatTicks <= 0) {
			c.field_5960 = false;
			return;
		}

		updateFloating(c);

		if (persistentData.floatTicks <= 0) {
			c.field_5960 = false;
		}
	}

	@NotNull
	@Override
	public class_2769<class_2768> method_9474() {
		return class_2741.field_12542;
	}
}
