/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.SparkTinkererBlockEntity;
import vazkii.botania.common.item.SparkAugmentItem;

public class SparkTinkererBlock extends BotaniaWaterloggedBlock implements class_2343 {

	private static final class_265 SHAPE = method_9541(0, 0, 0, 16, 3, 16);

	public SparkTinkererBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, true));
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		boolean power = world.method_49804(pos) > 0;
		boolean powered = state.method_11654(class_2741.field_12484);

		if (power && !powered) {
			((SparkTinkererBlockEntity) world.method_8321(pos)).doSwap();
			world.method_8652(pos, state.method_11657(class_2741.field_12484, true), class_2248.field_31029);
		} else if (!power && powered) {
			world.method_8652(pos, state.method_11657(class_2741.field_12484, false), class_2248.field_31029);
		}
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		SparkTinkererBlockEntity changer = (SparkTinkererBlockEntity) world.method_8321(pos);
		class_1799 pstack = player.method_5998(hand);
		class_1799 cstack = changer.getItemHandler().method_5438(0);
		if (!cstack.method_7960()) {
			changer.getItemHandler().method_5447(0, class_1799.field_8037);
			player.method_31548().method_7398(cstack);
			return class_1269.method_29236(world.method_8608());
		} else if (!pstack.method_7960() && pstack.method_7909() instanceof SparkAugmentItem) {
			changer.getItemHandler().method_5447(0, pstack.method_7971(1));
			changer.method_5431();

			return class_1269.method_29236(world.method_8608());
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
		if (!state.method_27852(newState.method_26204())) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof SimpleInventoryBlockEntity inventory) {
				class_1264.method_5451(world, pos, inventory.getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		SparkTinkererBlockEntity changer = (SparkTinkererBlockEntity) world.method_8321(pos);
		class_1799 stack = changer.getItemHandler().method_5438(0);
		if (!stack.method_7960() && stack.method_7909() instanceof SparkAugmentItem upgrade) {
			return upgrade.type.ordinal() + 1;
		}
		return 0;
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new SparkTinkererBlockEntity(pos, state);
	}

}
