/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.mixin.MobAccessor;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1299;
import net.minecraft.class_1545;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5425;

public class FelPumpkinBlock extends BotaniaBlock {
	private static final class_2960 LOOT_TABLE = prefix("fel_blaze");

	public FelPumpkinBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11035));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2741.field_12481);
	}

	@Override
	public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
		super.method_9615(state, world, pos, oldState, isMoving);

		if (!world.field_9236 && world.method_8320(pos.method_10074()).method_27852(class_2246.field_10576) && world.method_8320(pos.method_10087(2)).method_27852(class_2246.field_10576)) {
			world.method_8650(pos, false);
			world.method_8650(pos.method_10074(), false);
			world.method_8650(pos.method_10087(2), false);
			class_1545 blaze = class_1299.field_6099.method_5883(world);
			blaze.method_5808(pos.method_10263() + 0.5D, pos.method_10264() - 1.95D, pos.method_10260() + 0.5D, 0.0F, 0.0F);
			blaze.method_5971();
			((MobAccessor) blaze).setLootTable(LOOT_TABLE);
			blaze.method_5943((class_5425) world, world.method_8404(pos), class_3730.field_16467, null, null);
			world.method_8649(blaze);

			for (class_3222 player : world.method_18467(class_3222.class, blaze.method_5829().method_1014(5.0))) {
				class_174.field_1182.method_9124(player, blaze);
			}
		}
	}

	@Override
	public class_2680 method_9605(class_1750 context) {
		return method_9564().method_11657(class_2741.field_12481, context.method_8042().method_10153());
	}

	@NotNull
	@Override
	public class_2680 method_9569(@NotNull class_2680 state, class_2415 mirror) {
		return state.method_11657(class_2741.field_12481, mirror.method_10343(state.method_11654(class_2741.field_12481)));
	}

	@NotNull
	@Override
	public class_2680 method_9598(@NotNull class_2680 state, class_2470 rot) {
		return state.method_11657(class_2741.field_12481, rot.method_10503(state.method_11654(class_2741.field_12481)));
	}
}
