/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.block_entity.AnimatedTorchBlockEntity;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;

public class AnimatedTorchBlock extends BotaniaWaterloggedBlock implements class_2343 {

	private static final class_265 SHAPE = method_9541(0, 0, 0, 16, 4, 16);

	public AnimatedTorchBlock(class_2251 builder) {
		super(builder);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 hand, class_3965 hit) {
		if (playerIn.method_21823()) {
			((AnimatedTorchBlockEntity) worldIn.method_8321(pos)).handRotate();
			return class_1269.method_29236(worldIn.method_8608());
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
		((AnimatedTorchBlockEntity) world.method_8321(pos)).onPlace(entity);
	}

	@Override
	public boolean method_9506(class_2680 state) {
		return true;
	}

	@Override
	public int method_9603(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
		return method_9524(blockState, blockAccess, pos, side);
	}

	@Override
	public int method_9524(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
		AnimatedTorchBlockEntity tile = (AnimatedTorchBlockEntity) blockAccess.method_8321(pos);

		if (tile.rotating || !tile.directionInitialized) {
			return 0;
		}

		if (AnimatedTorchBlockEntity.SIDES[tile.side] == side) {
			return 15;
		}

		return 0;
	}

	@NotNull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new AnimatedTorchBlockEntity(pos, state);
	}

	@org.jetbrains.annotations.Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.ANIMATED_TORCH, AnimatedTorchBlockEntity::commonTick);
	}

	@Override
	public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
		// Block entity is already gone so best we can do is just notify everyone
		world.method_8408(pos, this);
		if (world instanceof class_3218 level) {
			for (class_2350 e : AnimatedTorchBlockEntity.SIDES) {
				level.method_8508(pos.method_10093(e), state.method_26204(), e.method_10153());
			}
		}
		super.method_9585(world, pos, state);
	}

}
