/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_5944;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.PixieModel;
import vazkii.botania.common.entity.PixieEntity;

public class PixieRenderer extends class_927<PixieEntity, PixieModel> {

	public PixieRenderer(class_5617.class_5618 ctx) {
		super(ctx, new PixieModel(ctx.method_32167(BotaniaModelLayers.PIXIE)), 0.0F);
	}

	@Override
	public void render(PixieEntity mob, float yaw, float partialTicks, class_4587 pos, class_4597 buffers, int light) {
		class_5944 shader = CoreShaders.doppleganger();
		if (shader != null) {
			shader.method_35785("BotaniaDisfiguration").method_1251(GaiaGuardianRenderer.DEFAULT_DISFIGURATION);
			shader.method_35785("BotaniaGrainIntensity").method_1251(GaiaGuardianRenderer.DEFAULT_GRAIN_INTENSITY);
		}
		super.method_4072(mob, yaw, partialTicks, pos, buffers, light);
	}

	@NotNull
	@Override
	public class_2960 getTextureLocation(@NotNull PixieEntity entity) {
		return ClientProxy.dootDoot
				? new class_2960(ResourcesLib.MODEL_PIXIE_HALLOWEEN)
				: new class_2960(ResourcesLib.MODEL_PIXIE);
	}
}
