/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import vazkii.botania.common.entity.CorporeaSparkEntity;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_310;
import net.minecraft.class_5617;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class CorporeaSparkRenderer extends BaseSparkRenderer<CorporeaSparkEntity> {
	private final class_1058 corporeaWorldSprite;
	private final class_1058 corporeaMasterWorldSprite;
	private final class_1058 corporeaCreativeWorldSprite;

	public CorporeaSparkRenderer(class_5617.class_5618 ctx) {
		super(ctx);
		var atlas = class_310.method_1551().method_1549(class_1723.field_21668);
		this.corporeaWorldSprite = Objects.requireNonNull(atlas.apply(prefix("item/corporea_spark")));
		this.corporeaMasterWorldSprite = Objects.requireNonNull(atlas.apply(prefix("item/corporea_spark_master")));
		this.corporeaCreativeWorldSprite = Objects.requireNonNull(atlas.apply(prefix("item/corporea_spark_creative")));
	}

	@Override
	public class_1058 getBaseIcon(CorporeaSparkEntity entity) {
		if (entity.isCreative()) {
			return this.corporeaCreativeWorldSprite;
		} else if (entity.isMaster()) {
			return this.corporeaMasterWorldSprite;
		} else {
			return this.corporeaWorldSprite;
		}
	}

}
