/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.red_string.RedStringBlockEntity;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.WandOfTheForestItem;

import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

public class RedStringBlockEntityRenderer<T extends RedStringBlockEntity> implements class_827<T> {
	// 0 -> none, 10 -> full
	private static int transparency = 0;

	public static void tick() {
		class_1657 player = class_310.method_1551().field_1724;
		boolean hasWand = player != null && PlayerHelper.hasHeldItemClass(player, WandOfTheForestItem.class);
		if (transparency > 0 && !hasWand) {
			transparency--;
		} else if (transparency < 10 && hasWand) {
			transparency++;
		}
	}

	public RedStringBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(RedStringBlockEntity tile, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		if (transparency <= 0) {
			return;
		}

		float sizeAlpha = transparency / 10.0F;
		int color = 0xFF0000 | ((int) (sizeAlpha * 255) << 24);

		class_2350 dir = tile.getOrientation();
		class_2338 bind = tile.getBinding();

		if (bind != null) {
			ms.method_22903();
			ms.method_22904(0.5, 0.5, 0.5);
			class_243 span = new class_243(bind.method_10263() - tile.method_11016().method_10263(), bind.method_10264() - tile.method_11016().method_10264(), bind.method_10260() - tile.method_11016().method_10260());
			class_243 step = span.method_1029().method_1021(0.025);
			class_243 cur = step;

			int stepCount = (int) (span.method_1033() / step.method_1033());

			double len = (double) -ClientTickHandler.ticksInGame / 100F + new Random(dir.ordinal() ^ tile.method_11016().hashCode()).nextInt(10000);
			double add = step.method_1033();
			double rand = Math.random() - 0.5;
			class_4588 buffer = buffers.getBuffer(RenderHelper.RED_STRING);
			for (int i = 0; i < stepCount; i++) {
				vertex(ms, buffer, color, dir, cur.field_1352, cur.field_1351, cur.field_1350, rand, len);
				rand = Math.random() - 0.5;
				cur = cur.method_1019(step);
				len += add;
				vertex(ms, buffer, color, dir, cur.field_1352, cur.field_1351, cur.field_1350, rand, len);
			}

			ms.method_22909();
		}
	}

	/**
	 * Add a vertex at the given position, but spiraled out perpendicular to {@code dir}
	 */
	private static void vertex(class_4587 ms, class_4588 buffer, int color, class_2350 dir,
			double xpos, double ypos, double zpos,
			double rand, double l) {
		float sizeAlpha = transparency / 10.0F;
		float ampl = (float) (0.15 * (class_3532.method_15374((float) l * 2F) * 0.5 + 0.5) + 0.1) * sizeAlpha;

		float trigInput = (float) (l * 20.0);
		float sin = class_3532.method_15374(trigInput);
		float cos = class_3532.method_15362(trigInput);
		float lastTerm = (float) (rand * 0.05);

		float x = (float) xpos
				+ sin * ampl * killNonZero(dir.method_10148())
				+ lastTerm;
		float y = (float) ypos
				+ cos * ampl * killNonZero(dir.method_10164())
				+ lastTerm;
		float z = (float) zpos
				+ (dir.method_10164() == 0 ? sin : cos) * ampl * killNonZero(dir.method_10165())
				+ lastTerm;

		int a = (color >> 24) & 0xFF;
		int r = (color >> 16) & 0xFF;
		int g = (color >> 8) & 0xFF;
		int b = color & 0xFF;
		buffer.method_22918(ms.method_23760().method_23761(), x, y, z).method_1336(r, g, b, a);
		switch (dir.method_10166().method_10180()) {
			case field_11062 -> buffer.method_23763(ms.method_23760().method_23762(), 0, 1, 0);
			case field_11064 -> buffer.method_23763(ms.method_23760().method_23762(), 1, 0, 0);
		}
		buffer.method_1344();
	}

	private static int killNonZero(int diff) {
		if (diff != 0) {
			return 0;
		} else {
			return 1;
		}
	}

}
