/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1087;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.block_entity.CocoonBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class CocoonBlockEntityRenderer implements class_827<CocoonBlockEntity> {
	private final class_776 blockRenderDispatcher;

	public CocoonBlockEntityRenderer(class_5614.class_5615 ctx) {
		this.blockRenderDispatcher = ctx.method_32141();
	}

	@Override
	public void render(@NotNull CocoonBlockEntity cocoon, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		float rot = 0F;
		float modval = 60F - (float) cocoon.timePassed / (float) CocoonBlockEntity.TOTAL_TIME * 30F;
		if (cocoon.timePassed % modval < 10) {
			float mod = (cocoon.timePassed + partialTicks) % modval;
			float v = mod / 5 * (float) Math.PI * 2;
			rot = (float) Math.sin(v) * (float) Math.log(cocoon.timePassed + partialTicks);
		}

		ms.method_22903();
		ms.method_22904(0.5, 0, 0);
		ms.method_22907(VecHelper.rotateX(rot));
		ms.method_22904(-0.5, 0, 0);
		class_2680 state = cocoon.method_11010();
		class_1087 model = blockRenderDispatcher.method_3349(state);
		class_4588 buffer = buffers.getBuffer(class_4696.method_23679(state));
		blockRenderDispatcher.method_3350().method_3367(ms.method_23760(), buffer, state, model, 1, 1, 1, light, overlay);
		ms.method_22909();
	}
}
