/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.BotanicalBreweryModel;
import vazkii.botania.common.block.block_entity.BreweryBlockEntity;

public class BotanicalBreweryBlockEntityRenderer implements class_827<BreweryBlockEntity> {
	final BotanicalBreweryModel model;

	public BotanicalBreweryBlockEntityRenderer(class_5614.class_5615 ctx) {
		model = new BotanicalBreweryModel(ctx.method_32140(BotaniaModelLayers.BREWERY));
	}

	@Override
	public void render(@Nullable BreweryBlockEntity brewery, float f, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();

		ms.method_22905(1F, -1F, -1F);
		ms.method_46416(0.5F, -1.5F, -0.5F);

		double time = ClientTickHandler.ticksInGame + f;

		model.render(brewery, time, ms, buffers, light, overlay);
		ms.method_22909();
	}

}
