/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import net.minecraft.class_1921;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import vazkii.botania.common.helper.VecHelper;

public class HourglassModel extends class_3879 {

	private final class_630 top;
	private final class_630 glassT;
	private final class_630 ring;
	private final class_630 glassB;
	private final class_630 bottom;

	private final class_630 sandT;
	private final class_630 sandB;

	public HourglassModel(class_630 root) {
		super(class_1921::method_23580);

		top = root.method_32086("top");
		glassT = root.method_32086("glass_top");
		ring = root.method_32086("ring");
		glassB = root.method_32086("glass_bottom");
		bottom = root.method_32086("bottom");
		sandT = root.method_32086("sand_top");
		sandB = root.method_32086("sand_bottom");
	}

	public static class_5609 createMesh() {
		var mesh = new class_5609();
		var root = mesh.method_32111();
		root.method_32117("top", class_5606.method_32108().method_32101(20, 0)
				.method_32097(-3.0F, -6.5F, -3.0F, 6, 1, 6), class_5603.field_27701);
		root.method_32117("glass_top", class_5606.method_32108()
				.method_32097(-2.5F, -5.5F, -2.5F, 5, 5, 5), class_5603.field_27701);
		root.method_32117("ring", class_5606.method_32108().method_32101(0, 20)
				.method_32097(-1.5F, -0.5F, -1.5F, 3, 1, 3), class_5603.field_27701);
		root.method_32117("glass_bottom", class_5606.method_32108().method_32101(0, 10)
				.method_32097(-2.5F, 0.5F, -2.5F, 5, 5, 5), class_5603.field_27701);
		root.method_32117("bottom", class_5606.method_32108().method_32101(20, 7)
				.method_32097(-3.0F, 5.5F, -3.0F, 6, 1, 6), class_5603.field_27701);
		root.method_32117("sand_top", class_5606.method_32108().method_32101(20, 14)
				.method_32097(0.0F, 0.0F, 0.0F, 4, 4, 4), class_5603.field_27701);
		root.method_32117("sand_bottom", class_5606.method_32108().method_32101(20, 14)
				.method_32097(0.0F, 0.0F, 0.0F, 4, 4, 4), class_5603.field_27701);
		return mesh;
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a) {
		render(ms, buffer, light, overlay, r, g, b, a, 0, 1, false);
	}

	public void render(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a, float fract1, float fract2, boolean flip) {
		if (flip) {
			float tmp = fract1;
			fract1 = fract2;
			fract2 = tmp;
		}

		float f = 1F / 16F;
		ring.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);
		top.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);
		bottom.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);

		if (fract1 > 0) {
			ms.method_22903();
			if (flip) {
				ms.method_46416(-2.0F * f, 1.0F * f, -2.0F * f);
			} else {
				ms.method_22907(VecHelper.rotateZ(180F));
				ms.method_46416(-2.0F * f, -5.0F * f, -2.0F * f);
			}
			ms.method_22905(1F, fract1, 1F);
			sandT.method_22699(ms, buffer, light, overlay, r, g, b, a);
			ms.method_22909();
		}

		if (fract2 > 0) {
			ms.method_22903();
			if (flip) {
				ms.method_46416(-2.0F * f, -5.0F * f, -2.0F * f);
			} else {
				ms.method_22907(VecHelper.rotateZ(180F));
				ms.method_46416(-2.0F * f, 1.0F * f, -2.0F * f);
			}
			ms.method_22905(1F, fract2, 1F);
			sandB.method_22699(ms, buffer, light, overlay, r, g, b, a);
			ms.method_22909();
		}

		glassT.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);
		glassB.method_22699(ms, buffer, light, overlay, 1, 1, 1, a);
	}

}
