/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.recipe;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;

public interface PureDaisyRecipe extends class_1860<class_1263> {
	class_2960 TYPE_ID = new class_2960(BotaniaAPI.MODID, "pure_daisy");

	/**
	 * This gets called every tick, please be careful with your checks.
	 */
	boolean matches(class_1937 world, class_2338 pos, SpecialFlowerBlockEntity pureDaisy, class_2680 state);

	/**
	 * Returns true if the block was placed (and if the Pure Daisy should do particles and stuffs).
	 * Should only place the block if !world.isRemote, but should return true if it would've placed
	 * it otherwise. You may return false to cancel the normal particles and do your own.
	 */
	boolean set(class_1937 world, class_2338 pos, SpecialFlowerBlockEntity pureDaisy);

	StateIngredient getInput();

	class_2680 getOutputState();

	class_2158.class_2159 getSuccessFunction();

	int getTime();

	@Override
	default class_3956<?> method_17716() {
		return class_7923.field_41188.method_10223(TYPE_ID);
	}

	@Override
	default boolean method_8115(class_1263 p_77569_1_, class_1937 p_77569_2_) {
		return false;
	}

	@Override
	default class_1799 method_8116(class_1263 container, @NotNull class_5455 registries) {
		return class_1799.field_8037;
	}

	@Override
	default boolean method_8113(int p_194133_1_, int p_194133_2_) {
		return false;
	}

	@Override
	default class_1799 method_8110(@NotNull class_5455 registries) {
		return class_1799.field_8037;
	}

	@Override
	default boolean method_8118() {
		return true;
	}
}
