/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.mana;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import java.util.List;

/**
 * Fired when the mod is gathering all items on a player that have mana.
 * For example, if you are an accessory mod, you would listen to this event and add stacks in your
 * accessory slots to the list.
 */
public interface ManaItemsCallback {
	Event<ManaItemsCallback> EVENT = EventFactory.createArrayBacked(ManaItemsCallback.class,
			listeners -> (pl, items) -> {
				for (ManaItemsCallback listener : listeners) {
					listener.getManaItems(pl, items);
				}
			});

	void getManaItems(class_1657 player, List<class_1799> items);
}
