/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BlockStateIngredient;
import vazkii.botania.common.crafting.BlockStateStateIngredient;
import vazkii.botania.common.crafting.BlocksStateIngredient;

public class CompoundStateIngredient
implements StateIngredient {
    protected final ImmutableSet<StateIngredient> ingredients;
    protected final Set<class_2680> resolvedBlocks;

    public CompoundStateIngredient(Collection<StateIngredient> ingredients) {
        this.ingredients = ImmutableSet.copyOf(ingredients);
        this.resolvedBlocks = new HashSet<class_2680>();
    }

    @Override
    public boolean test(class_2680 state) {
        for (StateIngredient sub : this.ingredients) {
            if (!sub.test(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_2680 pick(class_5819 random) {
        return new ArrayList<class_2680>(this.getBlocks()).get(random.method_43048(this.getBlocks().size()));
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "compound");
        JsonArray array = new JsonArray();
        for (StateIngredient ingredient : this.ingredients) {
            array.add((JsonElement)ingredient.serialize());
        }
        object.add("ingredients", (JsonElement)array);
        return object;
    }

    @Override
    public void write(class_2540 buffer) {
        ImmutableList ingredients = this.ingredients.asList();
        buffer.method_10804(3);
        buffer.method_10804(ingredients.size());
        for (StateIngredient ingredient : ingredients) {
            ingredient.write(buffer);
        }
    }

    @Override
    public List<class_1799> getDisplayedStacks() {
        return this.getBlocks().stream().map(class_4970.class_4971::method_26204).filter(b -> b.method_8389() != class_1802.field_8162).map(class_1799::new).collect(Collectors.toList());
    }

    @Override
    public List<class_2680> getDisplayed() {
        return new ArrayList<class_2680>(this.getBlocks());
    }

    @NotNull
    protected Set<class_2680> getBlocks() {
        if (this.resolvedBlocks.isEmpty()) {
            for (StateIngredient ingredient : this.ingredients) {
                if (ingredient instanceof BlockStateIngredient) {
                    BlockStateIngredient stateIngredient = (BlockStateIngredient)ingredient;
                    this.resolvedBlocks.add(stateIngredient.getBlock().method_9564());
                    continue;
                }
                if (ingredient instanceof BlockStateStateIngredient) {
                    BlockStateStateIngredient stateIngredient = (BlockStateStateIngredient)ingredient;
                    this.resolvedBlocks.add(stateIngredient.getState());
                    continue;
                }
                if (!(ingredient instanceof BlocksStateIngredient)) continue;
                BlocksStateIngredient stateIngredient = (BlocksStateIngredient)ingredient;
                for (class_2248 block : stateIngredient.getBlocks()) {
                    this.resolvedBlocks.add(block.method_9564());
                }
            }
        }
        return this.resolvedBlocks;
    }

    public ImmutableSet<StateIngredient> getIngredients() {
        return this.ingredients;
    }

    public String toString() {
        return "CompoundStateIngredient{" + this.getIngredients() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundStateIngredient that = (CompoundStateIngredient)o;
        return Objects.equals(this.ingredients, that.ingredients);
    }

    public int hashCode() {
        return this.ingredients != null ? this.ingredients.hashCode() : 0;
    }
}

