package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.configdata.LooniumMobAttributeModifier;
import vazkii.botania.api.configdata.LooniumMobEffectToApply;
import vazkii.botania.api.configdata.LooniumMobSpawnData;
import vazkii.botania.api.configdata.LooniumStructureConfiguration;
import vazkii.botania.common.loot.BotaniaLootTables;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_2405;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_5134;
import net.minecraft.class_7058;
import net.minecraft.class_7061;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class LooniumStructureConfigurationProvider implements class_2405 {

	public static final String LOONIUM_MODIFIER_DAMAGE = "Loonium Modifier Damage";
	public static final String LOONIUM_MODIFIER_HEALTH = "Loonium Modifier Health";
	private final class_7784.class_7489 pathProvider;

	public LooniumStructureConfigurationProvider(class_7784 packOutput) {
		pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loonium_config");
	}

	@NotNull
	@Override
	public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
		Map<class_2960, LooniumStructureConfiguration> configs = new HashMap<>();
		addConfigs(configs);

		var output = new ArrayList<CompletableFuture<?>>(configs.size());
		for (Map.Entry<class_2960, LooniumStructureConfiguration> e : configs.entrySet()) {
			Path path = pathProvider.method_44107(e.getKey());
			LooniumStructureConfiguration config = e.getValue();
			JsonElement jsonTree = LooniumStructureConfiguration.CODEC.encodeStart(JsonOps.INSTANCE, config)
					.getOrThrow(false, BotaniaAPI.LOGGER::error);
			output.add(class_2405.method_10320(cache, jsonTree, path));
		}
		return CompletableFuture.allOf(output.toArray(CompletableFuture<?>[]::new));
	}

	private void addConfigs(Map<class_2960, LooniumStructureConfiguration> configs) {
		class_2960 defaultConfigId = LooniumStructureConfiguration.DEFAULT_CONFIG_ID;
		configs.put(defaultConfigId, getDefaultConfig());

		configs.put(class_7058.field_38428.method_29177(), getConfigAncientCity(defaultConfigId));
		configs.put(class_7058.field_37186.method_29177(), getConfigBastionRemnant(defaultConfigId));
		configs.put(class_7058.field_37173.method_29177(), getConfigDesertPyramid(defaultConfigId));
		configs.put(class_7058.field_37184.method_29177(), getConfigEndCity(defaultConfigId));
		configs.put(class_7058.field_37182.method_29177(), getConfigFortress(defaultConfigId));
		configs.put(class_7058.field_37172.method_29177(), getConfigJungleTemple(defaultConfigId));
		configs.put(class_7058.field_37179.method_29177(), getConfigOceanMonument(defaultConfigId));

		class_2960 oceanRuinId = prefix("ocean_ruins");
		configs.put(oceanRuinId,
				LooniumStructureConfiguration.forParent(defaultConfigId)
						.boundingBoxType(class_7061.class_7062.field_37200).build()
		);
		configs.put(class_7058.field_37180.method_29177(), getConfigOceanRuinCold(oceanRuinId));
		configs.put(class_7058.field_37181.method_29177(), getConfigOceanRuinWarm(oceanRuinId));

		configs.put(class_7058.field_37168.method_29177(), getConfigPillagerOutpost(defaultConfigId));
		configs.put(class_7058.field_37193.method_29177(), getConfigRuinedPortalDesert(defaultConfigId));
		configs.put(class_7058.field_37163.method_29177(), getConfigRuinedPortalJungle(defaultConfigId));
		configs.put(class_7058.field_37165.method_29177(), getConfigRuinedPortalMountain(defaultConfigId));
		configs.put(class_7058.field_37167.method_29177(), getConfigRuinedPortalNether(defaultConfigId));
		configs.put(class_7058.field_37166.method_29177(), getConfigRuinedPortalOcean(defaultConfigId));
		configs.put(class_7058.field_37192.method_29177(), getConfigRuinedPortalStandard(defaultConfigId));
		configs.put(class_7058.field_37164.method_29177(), getConfigRuinedPortalSwamp(defaultConfigId));

		configs.put(class_7058.field_37175.method_29177(), getConfigShipwreck(defaultConfigId));
		configs.put(class_7058.field_37176.method_29177(),
				LooniumStructureConfiguration.forParent(class_7058.field_37175.method_29177()).build());

		configs.put(class_7058.field_37178.method_29177(), getConfigStronghold(defaultConfigId));
		configs.put(class_7058.field_43326.method_29177(), getConfigTrailRuins(defaultConfigId));

		class_2960 villageId = prefix("village");
		configs.put(villageId, LooniumStructureConfiguration.forParent(defaultConfigId)
				.boundingBoxType(class_7061.class_7062.field_37200).build()
		);
		configs.put(class_7058.field_37188.method_29177(), getConfigVillageDesert(villageId));
		configs.put(class_7058.field_37187.method_29177(), getConfigVillagePlains(villageId));
		configs.put(class_7058.field_37189.method_29177(), getConfigVillageSavanna(villageId));
		configs.put(class_7058.field_37190.method_29177(), getConfigVillageSnowy(villageId));
		configs.put(class_7058.field_37191.method_29177(), getConfigVillageTaiga(villageId));

		configs.put(class_7058.field_37171.method_29177(), getConfigWoodlandMansion(defaultConfigId));
	}

	public static LooniumStructureConfiguration getDefaultConfig() {
		return LooniumStructureConfiguration.builder()
				.manaCost(LooniumStructureConfiguration.DEFAULT_COST)
				.maxNearbyMobs(LooniumStructureConfiguration.DEFAULT_MAX_NEARBY_MOBS)
				.boundingBoxType(class_7061.class_7062.field_37199)
				.spawnedMobs(
						// weights roughly based on original Loonium mob selection logic
						LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
						getCreeperSpawnData(195, false, getCreeperEffects(false)),
						getCreeperSpawnData(1, true, getCreeperEffects(false)),
						LooniumMobSpawnData.entityWeight(class_1299.field_6071, 59)
								.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6123, 106)
								.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423)
								.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6098, 59)
								.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6137, 529)
								.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()
				)
				.attributeModifiers(
						new LooniumMobAttributeModifier(LOONIUM_MODIFIER_HEALTH,
								class_5134.field_23716, 2, class_1322.class_1323.field_6330),
						new LooniumMobAttributeModifier(LOONIUM_MODIFIER_DAMAGE,
								class_5134.field_23721, 1.5, class_1322.class_1323.field_6330)
				)
				.effectsToApply(getStandardEffects(false, true))
				.build();
	}

	public static LooniumStructureConfiguration getConfigAncientCity(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(),
				getCreeperSpawnData(99, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6071, 40)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 80)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_ANCIENT_CITY).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 410)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 60)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 440)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 100).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 200).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigBastionRemnant(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(),
				getCreeperSpawnData(99, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				getPiglinSpawnData(450, BotaniaLootTables.LOONIUM_PIGLIN_BASTION_REMNANT, false, false),
				LooniumMobSpawnData.entityWeight(class_1299.field_25751, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE_GOLD)
						.attributeModifiers(
								new LooniumMobAttributeModifier(LOONIUM_MODIFIER_HEALTH,
										class_5134.field_23716, 1.5, class_1322.class_1323.field_6330),
								new LooniumMobAttributeModifier(LOONIUM_MODIFIER_DAMAGE,
										class_5134.field_23721, 1.5, class_1322.class_1323.field_6330)
						)
						.build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_21973, 300).spawnAsAdult().build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigDesertPyramid(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 50).build(),
				getCreeperSpawnData(149, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6071, 450)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 500)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_DESERT_PYRAMID).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 40).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 360).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigEndCity(class_2960 parentId) {
		LooniumMobEffectToApply[] creeperEffects = {
				LooniumMobEffectToApply.effect(class_1294.field_5918).duration(100).build(),
				LooniumMobEffectToApply.effect(class_1294.field_5924).duration(100).build(),
				LooniumMobEffectToApply.effect(class_1294.field_5906).duration(400).build()
		};
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6109, 100)
						.effectsToApply(getStandardEffects(true, true)).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 300).build(),
				getCreeperSpawnData(99, false, creeperEffects),
				getCreeperSpawnData(1, true, creeperEffects),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 300)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_END_CITY).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 300)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_END_CITY).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 300).build()
		).effectsToApply(
				LooniumMobEffectToApply.effect(class_1294.field_5918).build(),
				LooniumMobEffectToApply.effect(class_1294.field_5924).build(),
				LooniumMobEffectToApply.effect(class_1294.field_5906).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigFortress(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(),
				getCreeperSpawnData(99, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6099, 300)
						.effectsToApply(getStandardEffects(false, false)).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6076, 450)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS)
						.effectsToApply(getStandardEffects(false, false)).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6050, 400)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_FORTRESS)
						.effectsToApply(getStandardEffects(false, false)).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigJungleTemple(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(),
				getCreeperSpawnData(149, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 40)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_JUNGLE_TEMPLE).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 360)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_JUNGLE_TEMPLE).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 500)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_JUNGLE_TEMPLE).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 300).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 300).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigOceanMonument(class_2960 parentId) {
		LooniumMobEffectToApply[] standardEffectsInWater = getStandardEffects(true, true);
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6118, 200).build(),
				getCreeperSpawnData(199, false, getCreeperEffects(true)),
				getCreeperSpawnData(1, true, getCreeperEffects(true)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_MONUMENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_MONUMENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 40)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 360)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30)
						.effectsToApply(standardEffectsInWater).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270)
						.effectsToApply(standardEffectsInWater).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigOceanRuinCold(class_2960 parentId) {
		LooniumMobEffectToApply[] standardEffectsInWater = getStandardEffects(true, true);
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				getCreeperSpawnData(199, false, getCreeperEffects(true)),
				getCreeperSpawnData(1, true, getCreeperEffects(true)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 40)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 360)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30)
						.effectsToApply(standardEffectsInWater).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270)
						.effectsToApply(standardEffectsInWater).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigOceanRuinWarm(class_2960 parentId) {
		LooniumMobEffectToApply[] standardEffectsInWater = getStandardEffects(true, true);
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				getCreeperSpawnData(199, false, getCreeperEffects(true)),
				getCreeperSpawnData(1, true, getCreeperEffects(true)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 400)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30)
						.effectsToApply(standardEffectsInWater).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270)
						.effectsToApply(standardEffectsInWater).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigPillagerOutpost(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId)
				.boundingBoxType(class_7061.class_7062.field_37200).spawnedMobs(
						LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
						getCreeperSpawnData(199, false, getCreeperEffects(false)),
						getCreeperSpawnData(1, true, getCreeperEffects(false)),
						LooniumMobSpawnData.entityWeight(class_1299.field_6105, 900)
								.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6117, 175)
								.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6090, 25).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6137, 200)
								.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_OUTPOST).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6051, 200)
								.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_OUTPOST).build(),
						LooniumMobSpawnData.entityWeight(class_1299.field_6079, 200).build()
				).build();
	}

	public static LooniumStructureConfiguration getConfigRuinedPortalDesert(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25)
						.effectsToApply(getStandardEffects(false, false)).build(),
				getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true),
				LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 50).build(),
				getCreeperSpawnData(149, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6071, 450)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 450)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 360).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigRuinedPortalJungle(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25)
						.effectsToApply(getStandardEffects(false, false)).build(),
				getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true),
				LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(),
				getCreeperSpawnData(149, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 40)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 360)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 500)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 250).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 50).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigRuinedPortalMountain(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25)
						.effectsToApply(getStandardEffects(false, false)).build(),
				getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true),
				LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(195, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 529)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 529)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6125, 59).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigRuinedPortalNether(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_23696, 125)
						.effectsToApply(getStandardEffects(false, false)).build(),
				getPiglinSpawnData(500, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, false),
				LooniumMobSpawnData.entityWeight(class_1299.field_6050, 450)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(195, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 200)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 10).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 90).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigRuinedPortalOcean(class_2960 parentId) {
		LooniumMobEffectToApply[] standardEffectsInWater = getStandardEffects(true, true);
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25)
						.effectsToApply(getStandardEffects(false, false)).build(),
				getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, true, true),
				LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				getCreeperSpawnData(199, false, getCreeperEffects(true)),
				getCreeperSpawnData(1, true, getCreeperEffects(true)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 400)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30)
						.effectsToApply(standardEffectsInWater).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270)
						.effectsToApply(standardEffectsInWater).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigRuinedPortalStandard(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25)
						.effectsToApply(getStandardEffects(false, false)).build(),
				getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true),
				LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(195, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6071, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 106)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 529)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigRuinedPortalSwamp(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25)
						.effectsToApply(getStandardEffects(false, false)).build(),
				getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true),
				LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(),
				getCreeperSpawnData(149, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 40)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 360)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 500)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 50).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 250).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigShipwreck(class_2960 parentId) {
		LooniumMobEffectToApply[] standardEffectsInWater = getStandardEffects(true, true);
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				getCreeperSpawnData(199, false, getCreeperEffects(true)),
				getCreeperSpawnData(1, true, getCreeperEffects(true)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_SHIPWRECK).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_SHIPWRECK).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 40)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 360)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30)
						.effectsToApply(standardEffectsInWater).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270)
						.effectsToApply(standardEffectsInWater).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigStronghold(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 80).build(),
				getCreeperSpawnData(149, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6071, 40)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 40)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_STRONGHOLD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 410)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 60)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 440)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 100).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6125, 100).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 400).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigTrailRuins(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(195, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6071, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 106)
						.equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_TRAIL_RUINS).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423)
						.equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 529)
						.equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigVillageDesert(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(195, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6071, 423)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 600)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigVillagePlains(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(195, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 600)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigVillageSavanna(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(195, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 30)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6071, 30)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 600)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigVillageSnowy(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(195, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 529)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigVillageTaiga(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(195, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6123, 59)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6098, 106)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 423)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()
		).build();
	}

	public static LooniumStructureConfiguration getConfigWoodlandMansion(class_2960 parentId) {
		return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(
				LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(),
				getCreeperSpawnData(199, false, getCreeperEffects(false)),
				getCreeperSpawnData(1, true, getCreeperEffects(false)),
				LooniumMobSpawnData.entityWeight(class_1299.field_6117, 600)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6105, 200)
						.equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6090, 100).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 150)
						.equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6051, 50).spawnAsBaby()
						.equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6137, 200)
						.equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30).build(),
				LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270).build()
		).build();
	}

	public static LooniumMobEffectToApply[] getStandardEffects(boolean withWaterBreathing, boolean withFireResistance) {
		return withFireResistance
				? (withWaterBreathing
						? new LooniumMobEffectToApply[] {
								LooniumMobEffectToApply.effect(class_1294.field_5918).build(),
								LooniumMobEffectToApply.effect(class_1294.field_5924).build(),
								LooniumMobEffectToApply.effect(class_1294.field_5923).build()
						}
						: new LooniumMobEffectToApply[] {
								LooniumMobEffectToApply.effect(class_1294.field_5918).build(),
								LooniumMobEffectToApply.effect(class_1294.field_5924).build()
						})
				: (withWaterBreathing
						? new LooniumMobEffectToApply[] {
								LooniumMobEffectToApply.effect(class_1294.field_5924).build(),
								LooniumMobEffectToApply.effect(class_1294.field_5923).build()
						}
						: new LooniumMobEffectToApply[] {
								LooniumMobEffectToApply.effect(class_1294.field_5924).build()
						});
	}

	public static LooniumMobEffectToApply[] getCreeperEffects(boolean withWaterBreathing) {
		return withWaterBreathing
				? new LooniumMobEffectToApply[] {
						LooniumMobEffectToApply.effect(class_1294.field_5918).duration(100).build(),
						LooniumMobEffectToApply.effect(class_1294.field_5924).duration(100).build(),
						LooniumMobEffectToApply.effect(class_1294.field_5923).build()
				}
				: new LooniumMobEffectToApply[] {
						LooniumMobEffectToApply.effect(class_1294.field_5918).duration(100).build(),
						LooniumMobEffectToApply.effect(class_1294.field_5924).duration(100).build()
				};
	}

	public static LooniumMobSpawnData getCreeperSpawnData(int weight, boolean charged,
			LooniumMobEffectToApply... creeperEffects) {
		class_2487 chargedCreeperNbt;
		if (charged) {
			chargedCreeperNbt = new class_2487();
			chargedCreeperNbt.method_10556("powered", true);
		} else {
			chargedCreeperNbt = null;
		}

		return LooniumMobSpawnData.entityWeight(class_1299.field_6046, weight)
				.nbt(chargedCreeperNbt)
				.effectsToApply(creeperEffects)
				.build();
	}

	public static LooniumMobSpawnData getPiglinSpawnData(int weight, class_2960 equipmentTable,
			boolean needWaterBreathing, boolean zombificationImmune) {
		class_2487 piglinNbt = new class_2487();
		if (zombificationImmune) {
			piglinNbt.method_10556("IsImmuneToZombification", true);
		}

		class_4095<class_1309> piglinBrain = class_4095.method_28311(List.of(class_4140.field_25361,
				class_4140.field_22473, class_4140.field_22350), List.of())
				.method_28335(new Dynamic<>(class_2509.field_11560));
		piglinBrain.method_18878(class_4140.field_25361, true);
		piglinBrain.method_18878(class_4140.field_22473, true);
		piglinBrain.method_18878(class_4140.field_22350, true);

		DataResult<class_2520> dataResult = piglinBrain.method_28310(class_2509.field_11560);
		dataResult.resultOrPartial(BotaniaAPI.LOGGER::error).ifPresent(tag -> piglinNbt.method_10566("Brain", tag));

		return LooniumMobSpawnData.entityWeight(class_1299.field_22281, weight)
				.spawnAsAdult()
				.nbt(piglinNbt)
				.equipmentTable(equipmentTable)
				.effectsToApply(getStandardEffects(needWaterBreathing, true))
				.build();
	}

	@NotNull
	@Override
	public String method_10321() {
		return "Loonium structure configuration";
	}
}
