/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2718;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_39;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.util.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.GaiaGuardianNoArmorTrigger;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.network.clientbound.SpawnGaiaGuardianPacket;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

import java.util.*;
import java.util.function.Supplier;

import static vazkii.botania.common.helper.PlayerHelper.isTruePlayer;
import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class GaiaGuardianEntity extends class_1308 {
	public static final float ARENA_RANGE = 12F;
	public static final int ARENA_HEIGHT = 5;

	private static final int SPAWN_TICKS = 160;
	public static final float MAX_HP = 320F;
	public static final Supplier<IMultiblock> ARENA_MULTIBLOCK = Suppliers.memoize(() -> {
		var beaconBase = PatchouliAPI.get().predicateMatcher(class_2246.field_10085,
				state -> state.method_26164(class_3481.field_22275));
		return PatchouliAPI.get().makeMultiblock(
				new String[][] {
						{
								"P_______P",
								"_________",
								"_________",
								"_________",
								"_________",
								"_________",
								"_________",
								"_________",
								"P_______P",
						},
						{
								"_________",
								"_________",
								"_________",
								"_________",
								"____B____",
								"_________",
								"_________",
								"_________",
								"_________",
						},
						{
								"_________",
								"_________",
								"_________",
								"___III___",
								"___I0I___",
								"___III___",
								"_________",
								"_________",
								"_________",
						}
				},
				'P', BotaniaBlocks.gaiaPylon,
				'B', class_2246.field_10327,
				'I', beaconBase,
				'0', beaconBase
		);
	});

	private static final int MOB_SPAWN_START_TICKS = 20;
	private static final int MOB_SPAWN_END_TICKS = 80;
	private static final int MOB_SPAWN_BASE_TICKS = 800;
	private static final int MOB_SPAWN_TICKS = MOB_SPAWN_BASE_TICKS + MOB_SPAWN_START_TICKS + MOB_SPAWN_END_TICKS;
	private static final int MOB_SPAWN_WAVES = 10;
	private static final int MOB_SPAWN_WAVE_TIME = MOB_SPAWN_BASE_TICKS / MOB_SPAWN_WAVES;
	private static final int DAMAGE_CAP = 32;

	private static final String TAG_INVUL_TIME = "invulTime";
	private static final String TAG_AGGRO = "aggro";
	private static final String TAG_SOURCE_X = "sourceX";
	private static final String TAG_SOURCE_Y = "sourceY";
	private static final String TAG_SOURCE_Z = "sourcesZ";
	private static final String TAG_MOB_SPAWN_TICKS = "mobSpawnTicks";
	private static final String TAG_HARD_MODE = "hardMode";
	private static final String TAG_PLAYER_COUNT = "playerCount";
	private static final class_6862<class_2248> BLACKLIST = BotaniaTags.Blocks.GAIA_BREAK_BLACKLIST;

	private static final class_2940<Integer> INVUL_TIME = class_2945.method_12791(GaiaGuardianEntity.class, class_2943.field_13327);

	private static final List<class_2338> PYLON_LOCATIONS = ImmutableList.of(
			new class_2338(4, 1, 4),
			new class_2338(4, 1, -4),
			new class_2338(-4, 1, 4),
			new class_2338(-4, 1, -4)
	);

	private static final List<class_2960> CHEATY_BLOCKS = Arrays.asList(
			new class_2960("openblocks", "beartrap"),
			new class_2960("thaumictinkerer", "magnet")
	);

	private boolean spawnLandmines = false;
	private boolean spawnPixies = false;
	private boolean anyWithArmor = false;
	private boolean aggro = false;
	private int tpDelay = 0;
	private int mobSpawnTicks = 0;
	private int playerCount = 0;
	private boolean hardMode = false;
	private class_2338 source = ManaBurst.NO_SOURCE;
	private final List<UUID> playersWhoAttacked = new ArrayList<>();
	private final class_3213 bossInfo = (class_3213) new class_3213(BotaniaEntities.DOPPLEGANGER.method_5897(), class_1259.class_1260.field_5788, class_1259.class_1261.field_5795).method_5411(true);
	private UUID bossInfoUUID = bossInfo.method_5407();
	public class_1657 trueKiller = null;

	public GaiaGuardianEntity(class_1299<GaiaGuardianEntity> type, class_1937 world) {
		super(type, world);
		field_6194 = 825;
		if (world.field_9236) {
			Proxy.INSTANCE.addBoss(this);
		}
	}

	public static boolean spawn(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, boolean hard) {
		//initial checks
		if (!(world.method_8321(pos) instanceof class_2580) ||
				!isTruePlayer(player) ||
				countGaiaGuardiansAround(world, pos) > 0) {
			return false;
		}

		//check difficulty
		if (world.method_8407() == class_1267.field_5801) {
			if (!world.field_9236) {
				player.method_43496(class_2561.method_43471("botaniamisc.peacefulNoob").method_27692(class_124.field_1061));
			}
			return false;
		}

		//check pylons
		List<class_2338> invalidPylonBlocks = checkPylons(world, pos);
		if (!invalidPylonBlocks.isEmpty()) {
			if (world.field_9236) {
				warnInvalidBlocks(world, invalidPylonBlocks);
			} else {
				player.method_43496(class_2561.method_43471("botaniamisc.needsCatalysts").method_27692(class_124.field_1061));
			}

			return false;
		}

		//check arena shape
		List<class_2338> invalidArenaBlocks = checkArena(world, pos);
		if (!invalidArenaBlocks.isEmpty()) {
			if (world.field_9236) {
				warnInvalidBlocks(world, invalidArenaBlocks);
			} else {
				XplatAbstractions.INSTANCE.sendToPlayer(player, new BotaniaEffectPacket(EffectType.ARENA_INDICATOR, pos.method_10263(), pos.method_10264(), pos.method_10260()));

				player.method_43496(class_2561.method_43471("botaniamisc.badArena").method_27692(class_124.field_1061));
			}

			return false;
		}

		//all checks ok, spawn the boss
		if (!world.field_9236) {
			stack.method_7934(1);

			GaiaGuardianEntity e = BotaniaEntities.DOPPLEGANGER.method_5883(world);
			e.method_5814(pos.method_10263() + 0.5, pos.method_10264() + 3, pos.method_10260() + 0.5);
			e.setInvulTime(SPAWN_TICKS);
			e.method_6033(1F);
			e.bossInfo.method_5408(0.0f);
			e.source = pos;
			e.mobSpawnTicks = MOB_SPAWN_TICKS;
			e.hardMode = hard;

			List<class_1657> playersAround = e.getPlayersAround();
			int playerCount = playersAround.size();
			e.playerCount = playerCount;

			float healthMultiplier = 1;
			if (playerCount > 1) {
				healthMultiplier += playerCount * 0.25F;
			}
			e.method_5996(class_5134.field_23716).method_6192(MAX_HP * healthMultiplier);

			if (hard) {
				e.method_5996(class_5134.field_23724).method_6192(15);
			}

			e.method_5783(BotaniaSounds.gaiaSummon, 1F, 1F);
			e.method_5943((class_5425) world, world.method_8404(e.method_24515()), class_3730.field_16467, null, null);
			world.method_8649(e);

			for (class_1657 nearbyPlayer : playersAround) {
				if (nearbyPlayer instanceof class_3222 serverPlayer) {
					class_174.field_1182.method_9124(serverPlayer, e);
				}
			}
		}

		return true;
	}

	private static List<class_2338> checkPylons(class_1937 world, class_2338 beaconPos) {
		List<class_2338> invalidPylonBlocks = new ArrayList<>();

		for (class_2338 coords : PYLON_LOCATIONS) {
			class_2338 pos_ = beaconPos.method_10081(coords);

			class_2680 state = world.method_8320(pos_);
			if (!state.method_27852(BotaniaBlocks.gaiaPylon)) {
				invalidPylonBlocks.add(pos_);
			}
		}

		return invalidPylonBlocks;
	}

	private static List<class_2338> checkArena(class_1937 world, class_2338 beaconPos) {
		List<class_2338> trippedPositions = new ArrayList<>();
		int range = (int) Math.ceil(ARENA_RANGE);
		class_2338 pos;

		for (int x = -range; x <= range; x++) {
			for (int z = -range; z <= range; z++) {
				if (Math.abs(x) == 4 && Math.abs(z) == 4 || MathHelper.pointDistancePlane(x, z, 0, 0) > ARENA_RANGE) {
					continue; // Ignore pylons and out of circle
				}

				boolean hasFloor = false;

				for (int y = -2; y <= ARENA_HEIGHT; y++) {
					if (x == 0 && y == 0 && z == 0) {
						continue; //the beacon
					}

					pos = beaconPos.method_10069(x, y, z);

					class_2680 state = world.method_8320(pos);

					boolean allowBlockHere = y < 0;
					boolean isBlockHere = !state.method_26220(world, pos).method_1110();

					if (allowBlockHere && isBlockHere) //floor is here! good
					{
						hasFloor = true;
					}

					if (y == 0 && !hasFloor) //column is entirely missing floor
					{
						trippedPositions.add(pos.method_10074());
					}

					if (!allowBlockHere && isBlockHere && !state.method_26164(BLACKLIST)) //ceiling is obstructed in this column
					{
						trippedPositions.add(pos);
					}
				}
			}
		}

		return trippedPositions;
	}

	private static void warnInvalidBlocks(class_1937 world, Iterable<class_2338> invalidPositions) {
		WispParticleData data = WispParticleData.wisp(0.5F, 1, 0.2F, 0.2F, 8, false);
		for (class_2338 pos_ : invalidPositions) {
			world.method_8406(data, pos_.method_10263() + 0.5, pos_.method_10264() + 0.5, pos_.method_10260() + 0.5, 0, 0, 0);
		}
	}

	@Override
	protected void method_5959() {
		field_6201.method_6277(0, new class_1347(this));
		field_6201.method_6277(1, new class_1361(this, class_1657.class, ARENA_RANGE * 1.5F));
	}

	@Override
	protected void method_5693() {
		super.method_5693();
		field_6011.method_12784(INVUL_TIME, 0);
	}

	public int getInvulTime() {
		return field_6011.method_12789(INVUL_TIME);
	}

	public class_2338 getSource() {
		return source;
	}

	public void setInvulTime(int time) {
		field_6011.method_12778(INVUL_TIME, time);
	}

	@Override
	public void method_5652(class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10569(TAG_INVUL_TIME, getInvulTime());
		cmp.method_10556(TAG_AGGRO, aggro);
		cmp.method_10569(TAG_MOB_SPAWN_TICKS, mobSpawnTicks);

		cmp.method_10569(TAG_SOURCE_X, source.method_10263());
		cmp.method_10569(TAG_SOURCE_Y, source.method_10264());
		cmp.method_10569(TAG_SOURCE_Z, source.method_10260());

		cmp.method_10556(TAG_HARD_MODE, hardMode);
		cmp.method_10569(TAG_PLAYER_COUNT, playerCount);
	}

	@Override
	public void method_5749(class_2487 cmp) {
		super.method_5749(cmp);
		setInvulTime(cmp.method_10550(TAG_INVUL_TIME));
		aggro = cmp.method_10577(TAG_AGGRO);
		mobSpawnTicks = cmp.method_10550(TAG_MOB_SPAWN_TICKS);

		int x = cmp.method_10550(TAG_SOURCE_X);
		int y = cmp.method_10550(TAG_SOURCE_Y);
		int z = cmp.method_10550(TAG_SOURCE_Z);
		source = new class_2338(x, y, z);

		hardMode = cmp.method_10577(TAG_HARD_MODE);
		if (cmp.method_10545(TAG_PLAYER_COUNT)) {
			playerCount = cmp.method_10550(TAG_PLAYER_COUNT);
		} else {
			playerCount = 1;
		}

		if (this.method_16914()) {
			this.bossInfo.method_5413(this.method_5476());
		}
	}

	@Override
	public void method_5665(@Nullable class_2561 name) {
		super.method_5665(name);
		this.bossInfo.method_5413(this.method_5476());
	}

	@Override
	public void method_6025(float amount) {
		if (getInvulTime() == 0) {
			super.method_6025(amount);
		}
	}

	@Override
	public void method_5768() {
		this.method_6033(0.0F);
	}

	@Override
	public boolean method_5643(@NotNull class_1282 source, float amount) {
		class_1297 e = source.method_5529();
		if (e instanceof class_1657 player && isTruePlayer(e) && getInvulTime() == 0) {

			if (!playersWhoAttacked.contains(player.method_5667())) {
				playersWhoAttacked.add(player.method_5667());
			}

			return super.method_5643(source, Math.min(DAMAGE_CAP, amount));
		}

		return false;
	}

	@Override
	protected void method_6074(@NotNull class_1282 source, float amount) {
		super.method_6074(source, Math.min(DAMAGE_CAP, amount));

		class_1297 attacker = source.method_5526();
		if (attacker != null) {
			class_243 thisVector = VecHelper.fromEntityCenter(this);
			class_243 playerVector = VecHelper.fromEntityCenter(attacker);
			class_243 motionVector = thisVector.method_1020(playerVector).method_1029().method_1021(0.75);

			if (method_6032() > 0) {
				method_18800(-motionVector.field_1352, 0.5, -motionVector.field_1350);
				tpDelay = 4;
				spawnPixies = true;
			}
		}
		field_6008 = Math.max(field_6008, 20);
	}

	@Override
	protected float method_6132(class_1282 source, float damage) {
		return super.method_6132(source, Math.min(DAMAGE_CAP, damage));
	}

	@Override
	public void method_6078(@NotNull class_1282 source) {
		super.method_6078(source);
		class_1309 lastAttacker = method_6124();

		if (!method_37908().field_9236) {
			for (UUID u : playersWhoAttacked) {
				class_1657 player = method_37908().method_18470(u);
				if (!isTruePlayer(player)) {
					continue;
				}
				class_1282 currSource = player == lastAttacker ? source : player.method_48923().method_48802(player);
				if (player != lastAttacker) {
					// Vanilla handles this in attack code, but only for the killer
					class_174.field_1192.method_8990((class_3222) player, this, currSource);
				}
				if (!anyWithArmor) {
					GaiaGuardianNoArmorTrigger.INSTANCE.trigger((class_3222) player, this, currSource);
				}
			}

			// Clear wither from nearby players
			for (class_1657 player : getPlayersAround()) {
				if (player.method_6112(class_1294.field_5920) != null) {
					player.method_6016(class_1294.field_5920);
				}
			}

			// Stop all the pixies leftover from the fight
			for (PixieEntity pixie : method_37908().method_8390(PixieEntity.class, getArenaBB(getSource()), p -> p.method_5805() && p.getPixieType() == 1)) {
				pixie.method_5990();
				pixie.method_31472();
			}
			for (MagicLandmineEntity landmine : method_37908().method_18467(MagicLandmineEntity.class, getArenaBB(getSource()))) {
				landmine.method_31472();
			}
		}

		method_5783(BotaniaSounds.gaiaDeath, 1F, (1F + (method_37908().field_9229.method_43057() - method_37908().field_9229.method_43057()) * 0.2F) * 0.7F);
		method_37908().method_8406(class_2398.field_11221, method_23317(), method_23318(), method_23321(), 1D, 0D, 0D);
	}

	@Override
	public boolean method_5974(double dist) {
		return false;
	}

	@Override
	public class_2960 method_5991() {
		if (mobSpawnTicks > 0) {
			return class_39.field_844;
		}
		return prefix(hardMode ? "gaia_guardian_2" : "gaia_guardian");
	}

	@Override
	protected void method_16077(@NotNull class_1282 source, boolean wasRecentlyHit) {
		// Save true killer, they get extra loot
		if (wasRecentlyHit && isTruePlayer(source.method_5529())) {
			trueKiller = (class_1657) source.method_5529();
		}

		// Generate loot table for every single attacking player
		for (UUID u : playersWhoAttacked) {
			class_1657 player = method_37908().method_18470(u);
			if (!isTruePlayer(player)) {
				continue;
			}

			class_1657 saveLastAttacker = field_6258;
			class_243 savePos = method_19538();

			field_6258 = player; // Fake attacking player as the killer
			// Spoof pos so drops spawn at the player
			method_5814(player.method_23317(), player.method_23318(), player.method_23321());
			super.method_16077(player.method_48923().method_48802(player), wasRecentlyHit);
			method_5814(savePos.method_10216(), savePos.method_10214(), savePos.method_10215());
			field_6258 = saveLastAttacker;
		}

		trueKiller = null;
	}

	@Override
	public void method_5650(class_5529 reason) {
		if (method_37908().field_9236) {
			Proxy.INSTANCE.removeBoss(this);
		}
		super.method_5650(reason);
	}

	public List<class_1657> getPlayersAround() {
		return PlayerHelper.getRealPlayersIn(method_37908(), getArenaBB(source));
	}

	public int getPlayerCount() {
		return playerCount;
	}

	private static int countGaiaGuardiansAround(class_1937 world, class_2338 source) {
		List<GaiaGuardianEntity> l = world.method_18467(GaiaGuardianEntity.class, getArenaBB(source));
		return l.size();
	}

	@NotNull
	private static class_238 getArenaBB(@NotNull class_2338 source) {
		double range = 15.0;
		return new class_238(source.method_10263() + 0.5 - range, source.method_10264() + 0.5 - range, source.method_10260() + 0.5 - range, source.method_10263() + 0.5 + range, source.method_10264() + 0.5 + range, source.method_10260() + 0.5 + range);
	}

	private void particles() {
		for (int i = 0; i < 360; i += 8) {
			float r = 0.6F;
			float g = 0F;
			float b = 0.2F;
			float m = 0.15F;
			float mv = 0.35F;

			float rad = i * (float) Math.PI / 180F;
			double x = source.method_10263() + 0.5 - Math.cos(rad) * ARENA_RANGE;
			double y = source.method_10264() + 0.5;
			double z = source.method_10260() + 0.5 - Math.sin(rad) * ARENA_RANGE;

			WispParticleData data = WispParticleData.wisp(0.5F, r, g, b);
			method_37908().method_8406(data, x, y, z, (float) (Math.random() - 0.5F) * m, (float) (Math.random() - 0.5F) * mv, (float) (Math.random() - 0.5F) * m);
		}

		if (getInvulTime() > 10) {
			class_243 pos = VecHelper.fromEntityCenter(this).method_1023(0, 0.2, 0);
			for (class_2338 arr : PYLON_LOCATIONS) {
				class_243 pylonPos = new class_243(source.method_10263() + arr.method_10263(), source.method_10264() + arr.method_10264(), source.method_10260() + arr.method_10260());
				double worldTime = field_6012;
				worldTime /= 5;

				float rad = 0.75F + (float) Math.random() * 0.05F;
				double xp = pylonPos.field_1352 + 0.5 + Math.cos(worldTime) * rad;
				double zp = pylonPos.field_1350 + 0.5 + Math.sin(worldTime) * rad;

				class_243 partPos = new class_243(xp, pylonPos.field_1351, zp);
				class_243 mot = pos.method_1020(partPos).method_1021(0.04);

				float r = 0.7F + (float) Math.random() * 0.3F;
				float g = (float) Math.random() * 0.3F;
				float b = 0.7F + (float) Math.random() * 0.3F;

				WispParticleData data = WispParticleData.wisp(0.25F + (float) Math.random() * 0.1F, r, g, b, 1);
				method_37908().method_8406(data, partPos.field_1352, partPos.field_1351, partPos.field_1350, 0, -(-0.075F - (float) Math.random() * 0.015F), 0);
				WispParticleData data1 = WispParticleData.wisp(0.4F, r, g, b);
				method_37908().method_8406(data1, partPos.field_1352, partPos.field_1351, partPos.field_1350, (float) mot.field_1352, (float) mot.field_1351, (float) mot.field_1350);
			}
		}
	}

	private void smashBlocksAround(int centerX, int centerY, int centerZ, int radius) {
		for (int dx = -radius; dx <= radius; dx++) {
			for (int dy = -radius; dy <= radius + 1; dy++) {
				for (int dz = -radius; dz <= radius; dz++) {
					int x = centerX + dx;
					int y = centerY + dy;
					int z = centerZ + dz;

					class_2338 pos = new class_2338(x, y, z);
					class_2680 state = method_37908().method_8320(pos);
					class_2248 block = state.method_26204();

					if (state.method_26214(method_37908(), pos) == -1) {
						continue;
					}

					if (CHEATY_BLOCKS.contains(class_7923.field_41175.method_10221(block))) {
						method_37908().method_22352(pos, true);
					} else {
						//don't break blacklisted blocks
						if (state.method_26164(BLACKLIST)) {
							continue;
						}
						//don't break the floor
						if (y < source.method_10264()) {
							continue;
						}
						//don't break blocks in pylon columns
						if (Math.abs(source.method_10263() - x) == 4 && Math.abs(source.method_10260() - z) == 4) {
							continue;
						}

						method_37908().method_22352(pos, true);
					}
				}
			}
		}
	}

	private void clearPotions(class_1657 player) {
		Set<class_1291> effectsToRemove = new HashSet<>();
		for (var effectInstance : player.method_6026()) {
			if (effectInstance.method_5584() < 160 && effectInstance.method_5591() && effectInstance.method_5579().method_18792() != class_4081.field_18272) {
				effectsToRemove.add(effectInstance.method_5579());
			}
		}

		for (var effect : effectsToRemove) {
			player.method_6016(effect);
			((class_3218) method_37908()).method_14178().method_18751(player,
					new class_2718(player.method_5628(), effect));
		}
	}

	private void keepInsideArena(class_1657 player) {
		if (MathHelper.pointDistanceSpace(player.method_23317(), player.method_23318(), player.method_23321(), source.method_10263() + 0.5, source.method_10264() + 0.5, source.method_10260() + 0.5) >= ARENA_RANGE) {
			class_243 sourceVector = new class_243(source.method_10263() + 0.5, source.method_10264() + 0.5, source.method_10260() + 0.5);
			class_243 playerVector = VecHelper.fromEntityCenter(player);
			class_243 motion = sourceVector.method_1020(playerVector).method_1029();

			player.method_18800(motion.field_1352, 0.2, motion.field_1350);
			player.field_6037 = true;
		}
	}

	private void spawnMobs(List<class_1657> players) {
		for (int pl = 0; pl < playerCount; pl++) {
			for (int i = 0; i < 3 + method_37908().field_9229.method_43048(2); i++) {
				class_1308 entity = switch (method_37908().field_9229.method_43048(3)) {
					case 0 -> {
						if (method_37908().field_9229.method_43048(hardMode ? 3 : 12) == 0) {
							yield class_1299.field_6145.method_5883(method_37908());
						}
						yield class_1299.field_6051.method_5883(method_37908());
					}
					case 1 -> {
						if (method_37908().field_9229.method_43048(8) == 0) {
							yield class_1299.field_6076.method_5883(method_37908());
						}
						yield class_1299.field_6137.method_5883(method_37908());
					}
					case 2 -> {
						if (!players.isEmpty()) {
							for (int j = 0; j < 1 + method_37908().field_9229.method_43048(hardMode ? 8 : 5); j++) {
								PixieEntity pixie = new PixieEntity(method_37908());
								pixie.setProps(players.get(field_5974.method_43048(players.size())), this, 1, 8);
								pixie.method_5814(method_23317() + method_17681() / 2, method_23318() + 2, method_23321() + method_17681() / 2);
								pixie.method_5943((class_5425) method_37908(), method_37908().method_8404(pixie.method_24515()),
										class_3730.field_16471, null, null);
								method_37908().method_8649(pixie);
							}
						}
						yield null;
					}
					default -> null;
				};

				if (entity != null) {
					if (!entity.method_5753()) {
						entity.method_6092(new class_1293(class_1294.field_5918, 600, 0));
					}
					float range = 6F;
					entity.method_5814(method_23317() + 0.5 + Math.random() * range - range / 2, method_23318() - 1,
							method_23321() + 0.5 + Math.random() * range - range / 2);
					entity.method_5943((class_5425) method_37908(), method_37908().method_8404(entity.method_24515()),
							class_3730.field_16471, null, null);
					if (entity instanceof class_1639 && hardMode) {
						entity.method_5673(class_1304.field_6173, new class_1799(BotaniaItems.elementiumSword));
					}
					method_37908().method_8649(entity);
				}
			}
		}
	}

	@Override
	public void method_6007() {
		super.method_6007();

		int invul = getInvulTime();

		if (method_37908().field_9236) {
			particles();
			class_1657 player = Proxy.INSTANCE.getClientPlayer();
			if (getPlayersAround().contains(player)) {
				player.method_31549().field_7479 &= player.method_31549().field_7477;
			}
			return;
		}

		bossInfo.method_5408(method_6032() / method_6063());

		if (method_5765()) {
			method_5848();
		}

		if (method_37908().method_8407() == class_1267.field_5801) {
			method_31472();
		}

		smashBlocksAround(class_3532.method_15357(method_23317()), class_3532.method_15357(method_23318()), class_3532.method_15357(method_23321()), 1);

		List<class_1657> players = getPlayersAround();

		if (players.isEmpty() && !method_37908().method_18456().isEmpty()) {
			method_31472();
		} else {
			for (class_1657 player : players) {
				for (class_1304 e : class_1304.values()) {
					if (e.method_5925() == class_1304.class_1305.field_6178 && !player.method_6118(e).method_7960()) {
						anyWithArmor = true;
						break;
					}
				}

				//also see SleepingHandler
				if (player.method_6113()) {
					player.method_18400();
				}

				clearPotions(player);
				keepInsideArena(player);
				player.method_31549().field_7479 &= player.method_31549().field_7477;
			}
		}

		if (!method_5805() || players.isEmpty()) {
			return;
		}

		boolean spawnMissiles = hardMode && field_6012 % 15 < 4;

		if (invul > 0 && mobSpawnTicks == MOB_SPAWN_TICKS) {
			if (invul < SPAWN_TICKS) {
				if (invul > SPAWN_TICKS / 2 && method_37908().field_9229.method_43048(SPAWN_TICKS - invul + 1) == 0) {
					for (int i = 0; i < 2; i++) {
						method_5990();
					}
				}
			}

			method_6033(method_6032() + (method_6063() - 1F) / SPAWN_TICKS);
			setInvulTime(invul - 1);

			method_18800(method_18798().method_10216(), 0, method_18798().method_10215());
		} else {
			if (aggro) {
				boolean dying = method_6032() / method_6063() < 0.2;
				if (dying && mobSpawnTicks > 0) {
					method_18799(class_243.field_1353);

					int reverseTicks = MOB_SPAWN_TICKS - mobSpawnTicks;
					if (reverseTicks < MOB_SPAWN_START_TICKS) {
						method_18800(method_18798().method_10216(), 0.2, method_18798().method_10215());
						setInvulTime(invul + 1);
					}

					if (reverseTicks > MOB_SPAWN_START_TICKS * 2 && mobSpawnTicks > MOB_SPAWN_END_TICKS && mobSpawnTicks % MOB_SPAWN_WAVE_TIME == 0) {
						spawnMobs(players);

						if (hardMode && field_6012 % 3 < 2) {
							for (int i = 0; i < playerCount; i++) {
								spawnMissile();
							}
							spawnMissiles = false;
						}
					}

					mobSpawnTicks--;
					tpDelay = 10;
				} else if (tpDelay > 0) {
					if (invul > 0) {
						setInvulTime(invul - 1);
					}

					tpDelay--;
					if (tpDelay == 0 && method_6032() > 0) {
						teleportRandomly();

						if (spawnLandmines) {
							int count = dying && hardMode ? 7 : 6;
							for (int i = 0; i < count; i++) {
								int x = source.method_10263() - 10 + field_5974.method_43048(20);
								int y = (int) players.get(field_5974.method_43048(players.size())).method_23318();
								int z = source.method_10260() - 10 + field_5974.method_43048(20);

								MagicLandmineEntity landmine = BotaniaEntities.MAGIC_LANDMINE.method_5883(method_37908());
								landmine.method_5814(x + 0.5, y, z + 0.5);
								landmine.summoner = this;
								method_37908().method_8649(landmine);
							}

						}

						for (int pl = 0; pl < playerCount; pl++) {
							for (int i = 0; i < (spawnPixies ? method_37908().field_9229.method_43048(hardMode ? 6 : 3) : 1); i++) {
								PixieEntity pixie = new PixieEntity(method_37908());
								pixie.setProps(players.get(field_5974.method_43048(players.size())), this, 1, 8);
								pixie.method_5814(method_23317() + method_17681() / 2, method_23318() + 2, method_23321() + method_17681() / 2);
								pixie.method_5943((class_5425) method_37908(), method_37908().method_8404(pixie.method_24515()),
										class_3730.field_16471, null, null);
								method_37908().method_8649(pixie);
							}
						}

						tpDelay = hardMode ? dying ? 35 : 45 : dying ? 40 : 60;
						spawnLandmines = true;
						spawnPixies = false;
					}
				}

				if (spawnMissiles) {
					spawnMissile();
				}
			} else {
				tpDelay = 30; // Trigger first teleport
				aggro = true;
			}
		}
	}

	@Override
	public boolean method_5822() {
		return false;
	}

	@Override
	public void method_5837(class_3222 player) {
		super.method_5837(player);
		bossInfo.method_14088(player);
	}

	@Override
	public void method_5742(class_3222 player) {
		super.method_5742(player);
		bossInfo.method_14089(player);
	}

	@Override
	protected void method_6070() {
		if (getInvulTime() == 0) {
			super.method_6070();
		}
	}

	@Override
	public boolean method_5810() {
		return super.method_5810() && getInvulTime() == 0;
	}

	private void spawnMissile() {
		MagicMissileEntity missile = new MagicMissileEntity(this, true);
		missile.method_5814(method_23317() + (Math.random() - 0.5 * 0.1), method_23318() + 2.4 + (Math.random() - 0.5 * 0.1), method_23321() + (Math.random() - 0.5 * 0.1));
		if (missile.findTarget()) {
			method_5783(BotaniaSounds.missile, 1F, 0.8F + (float) Math.random() * 0.2F);
			method_37908().method_8649(missile);
		}
	}

	private void teleportRandomly() {
		//choose a location to teleport to
		double oldX = method_23317(), oldY = method_23318(), oldZ = method_23321();
		double newX, newY = source.method_10264(), newZ;
		int tries = 0;

		do {
			newX = source.method_10263() + (field_5974.method_43058() - .5) * ARENA_RANGE;
			newZ = source.method_10260() + (field_5974.method_43058() - .5) * ARENA_RANGE;
			tries++;
			//ensure it's inside the arena ring, and not just its bounding square
		} while (tries < 50 && MathHelper.pointDistanceSpace(newX, newY, newZ, source.method_10263(), source.method_10264(), source.method_10260()) > 12);

		if (tries == 50) {
			//failsafe: teleport to the beacon
			newX = source.method_10263() + .5;
			newY = source.method_10264() + 1.6;
			newZ = source.method_10260() + .5;
		}

		//for low-floor arenas, ensure landing on the ground
		class_2338 tentativeFloorPos = class_2338.method_49637(newX, newY - 1, newZ);
		if (method_37908().method_8320(tentativeFloorPos).method_26220(method_37908(), tentativeFloorPos).method_1110()) {
			newY--;
		}

		//teleport there
		method_5859(newX, newY, newZ);

		//play sound
		method_37908().method_43128(null, oldX, oldY, oldZ, BotaniaSounds.gaiaTeleport, this.method_5634(), 1F, 1F);
		this.method_5783(BotaniaSounds.gaiaTeleport, 1F, 1F);

		var random = method_6051();

		//spawn particles along the path
		int particleCount = 128;
		for (int i = 0; i < particleCount; ++i) {
			double progress = i / (double) (particleCount - 1);
			float vx = (random.method_43057() - 0.5F) * 0.2F;
			float vy = (random.method_43057() - 0.5F) * 0.2F;
			float vz = (random.method_43057() - 0.5F) * 0.2F;
			double px = oldX + (newX - oldX) * progress + (random.method_43058() - 0.5D) * method_17681() * 2.0D;
			double py = oldY + (newY - oldY) * progress + random.method_43058() * method_17682();
			double pz = oldZ + (newZ - oldZ) * progress + (random.method_43058() - 0.5D) * method_17681() * 2.0D;
			method_37908().method_8406(class_2398.field_11214, px, py, pz, vx, vy, vz);
		}

		class_243 oldPosVec = new class_243(oldX, oldY + method_17682() / 2, oldZ);
		class_243 newPosVec = new class_243(newX, newY + method_17682() / 2, newZ);

		if (oldPosVec.method_1025(newPosVec) > 1) {
			//damage players in the path of the teleport
			for (class_1657 player : getPlayersAround()) {
				boolean hit = player.method_5829().method_1014(0.25).method_992(oldPosVec, newPosVec)
						.isPresent();
				if (hit) {
					player.method_5643(method_48923().method_48812(this), 6);
				}
			}

			//break blocks in the path of the teleport
			int breakSteps = (int) oldPosVec.method_1022(newPosVec);
			if (breakSteps >= 2) {
				for (int i = 0; i < breakSteps; i++) {
					float progress = i / (float) (breakSteps - 1);
					int breakX = class_3532.method_15357(oldX + (newX - oldX) * progress);
					int breakY = class_3532.method_15357(oldY + (newY - oldY) * progress);
					int breakZ = class_3532.method_15357(oldZ + (newZ - oldZ) * progress);

					smashBlocksAround(breakX, breakY, breakZ, 1);
				}
			}
		}
	}

	public UUID getBossInfoUuid() {
		return bossInfoUUID;
	}

	public boolean isHardMode() {
		return hardMode;
	}

	public void readSpawnData(int playerCount, boolean hardMode, class_2338 source, UUID bossInfoUUID) {
		this.playerCount = playerCount;
		this.hardMode = hardMode;
		this.source = source;
		this.bossInfoUUID = bossInfoUUID;
		Proxy.INSTANCE.runOnClient(() -> () -> DopplegangerMusic.play(this));
	}

	@Override
	public class_2596<class_2602> method_18002() {
		return XplatAbstractions.INSTANCE.toVanillaClientboundPacket(
				new SpawnGaiaGuardianPacket(new class_2604(this), playerCount, hardMode, source, bossInfoUUID));
	}

	@Override
	public boolean method_5931(class_1657 player) {
		return false;
	}

	private static class DopplegangerMusic extends class_1101 {
		private final GaiaGuardianEntity guardian;

		private DopplegangerMusic(GaiaGuardianEntity guardian) {
			super(guardian.hardMode ? BotaniaSounds.gaiaMusic2 : BotaniaSounds.gaiaMusic1, class_3419.field_15247, class_1113.method_43221());
			this.guardian = guardian;
			this.field_5439 = guardian.getSource().method_10263();
			this.field_5450 = guardian.getSource().method_10264();
			this.field_5449 = guardian.getSource().method_10260();
			this.field_5446 = true;
		}

		public static void play(GaiaGuardianEntity guardian) {
			class_310.method_1551().method_1483().method_4873(new DopplegangerMusic(guardian));
		}

		@Override
		public void method_16896() {
			if (!guardian.method_5805()) {
				method_24876();
			}
		}
	}
}
