/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;

import java.util.List;
import net.minecraft.class_1294;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1606;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5712;

public class ShulkMeNotBlockEntity extends GeneratingFlowerBlockEntity {
	private static final int RADIUS = 8;
	private static final int MANA_PER_SHULKER = 75000;

	public ShulkMeNotBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.SHULK_ME_NOT, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		class_1937 world = method_10997();
		if (world.field_9236) {
			return;
		}
		int generate = getMaxMana();
		if (getMaxMana() - getMana() < generate) {
			return;
		}

		class_2338 pos = getEffectivePos();
		class_243 posD = new class_243(pos.method_10263(), pos.method_10264(), pos.method_10260());
		List<class_1606> shulkers = world.method_8390(class_1606.class, new class_238(pos).method_1014(RADIUS), class_1301.field_6154);
		for (class_1606 shulker : shulkers) {
			if (getMaxMana() - getMana() < generate) {
				break;
			}

			if (shulker.method_5805() && shulker.method_5707(posD) < RADIUS * RADIUS) {
				class_1309 target = shulker.method_5968();
				if (target instanceof class_1569 && target.method_5805()
						&& target.method_5707(posD) < RADIUS * RADIUS && target.method_6112(class_1294.field_5902) != null) {
					target.method_31472();
					shulker.method_31472();

					world.method_8396(null, pos, BotaniaSounds.shulkMeNot, class_3419.field_15245, 10F, 1F);
					world.method_43129(null, target, BotaniaSounds.shulkMeNot, class_3419.field_15245, 10F, 1F);
					world.method_43129(null, shulker, BotaniaSounds.shulkMeNot, class_3419.field_15245, 10F, 1F);
					if (world instanceof class_3218 ws) {
						ws.method_14199(class_2398.field_11236,
								target.method_23317(), target.method_23318() + target.method_17682() / 2, target.method_23321(),
								100, target.method_17681(), target.method_17682(), target.method_17681(), 0.05);
						ws.method_14199(class_2398.field_11236,
								shulker.method_23317(), shulker.method_23318() + shulker.method_17682() / 2, shulker.method_23321(),
								100, shulker.method_17681(), shulker.method_17682(), shulker.method_17681(), 0.05);
						ws.method_14199(class_2398.field_11214,
								pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5,
								40, 0, 0, 0, 0.6);
					}

					world.method_33596(null, class_5712.field_28174, pos);
					addMana(generate);
					sync();
				}
			}
		}
	}

	@Override
	public int getColor() {
		return 0x815598;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Circle(getEffectivePos(), RADIUS);
	}

	@Override
	public int getMaxMana() {
		return MANA_PER_SHULKER;
	}

}
