/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.corporea;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.helper.FilterHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_6012;

public class CorporeaFunnelBlockEntity extends BaseCorporeaBlockEntity implements CorporeaRequestor {
	private static final int[] ROTATION_TO_STACK_SIZE = { 1, 2, 4, 8, 16, 32, 48, 64 };

	public CorporeaFunnelBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.CORPOREA_FUNNEL, pos, state);
	}

	public void doRequest() {
		CorporeaSpark spark = getSpark();
		if (spark != null && spark.getMaster() != null) {
			class_6012<FilterHelper.WeightedItemStack> filter = getFilter();
			if (!filter.method_34993()) {
				class_1799 stack = filter.method_34992(field_11863.field_9229)
						.map(FilterHelper.WeightedItemStack::stack)
						.orElse(class_1799.field_8037);

				if (!stack.method_7960()) {
					var matcher = CorporeaHelper.instance().createMatcher(stack, true);
					doCorporeaRequest(matcher, stack.method_7947(), spark, null);
				}
			}
		}
	}

	public class_6012<FilterHelper.WeightedItemStack> getFilter() {
		List<FilterHelper.WeightedItemStack> filter = new ArrayList<>();

		for (class_2350 dir : class_2350.values()) {
			List<class_1533> frames = field_11863.method_18467(class_1533.class, new class_238(field_11867.method_10093(dir), field_11867.method_10093(dir).method_10069(1, 1, 1)));
			for (class_1533 frame : frames) {
				class_2350 orientation = frame.method_5735();
				if (orientation == dir) {
					List<class_1799> filterStacks = FilterHelper.getFilterItems(frame);
					if (!filterStacks.isEmpty()) {
						int stackSize = ROTATION_TO_STACK_SIZE[frame.method_6934()];
						filterStacks.stream()
								.map(s -> FilterHelper.WeightedItemStack.of(s.method_46651(stackSize), s.method_7947()))
								.forEach(filter::add);
					}
				}
			}
		}

		return class_6012.method_34988(filter);
	}

	@Override
	public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable class_1309 entity) {
		class_2338 invPos = getInvPos();

		List<class_1799> stacks = CorporeaHelper.instance().requestItem(request, count, spark, entity, true).stacks();
		spark.onItemsRequested(stacks);
		for (class_1799 reqStack : stacks) {
			if (invPos != null
					&& XplatAbstractions.INSTANCE.insertToInventory(field_11863, invPos, class_2350.field_11036, reqStack, true).method_7960()) {
				InventoryHelper.checkEmpty(
						XplatAbstractions.INSTANCE.insertToInventory(field_11863, invPos, class_2350.field_11036, reqStack, false)
				);
			} else {
				class_1542 item = new class_1542(field_11863, spark.entity().method_23317(), spark.entity().method_23318(), spark.entity().method_23321(), reqStack);
				field_11863.method_8649(item);
			}
		}
	}

	@Nullable
	private class_2338 getInvPos() {
		class_2338 downOne = field_11867.method_10074();
		if (XplatAbstractions.INSTANCE.hasInventory(field_11863, downOne, class_2350.field_11036)) {
			return downOne;
		}

		class_2338 downTwo = field_11867.method_10087(2);
		if (XplatAbstractions.INSTANCE.hasInventory(field_11863, downTwo, class_2350.field_11036)) {
			return downTwo;
		}

		return null;
	}

}
