/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;

public class LifeImbuerBlockEntity extends BotaniaBlockEntity implements ManaReceiver {
	private static final String TAG_MANA = "mana";
	private static final int MAX_MANA = 160;

	private int mana = 0;

	public LifeImbuerBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.SPAWNER_CLAW, pos, state);
	}

	public static void onSpawnerNearPlayer(class_1937 level, class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
		if (!level.method_8320(pos).method_27852(class_2246.field_10260)) {
			return;
		}
		class_2338 up = pos.method_10084();
		if (level.method_8320(up).method_27852(BotaniaBlocks.spawnerClaw)) {
			class_2586 be = level.method_8321(pos.method_10084());

			if (be instanceof LifeImbuerBlockEntity claw && claw.mana > 5) {
				claw.receiveMana(-6);
				if (level.field_9236 && Math.random() > 0.5) {
					WispParticleData data = WispParticleData.wisp((float) Math.random() / 3F, 0.6F - (float) Math.random() * 0.3F, 0.1F, 0.6F - (float) Math.random() * 0.3F, 2F);
					level.method_8406(data, up.method_10263() + 0.3 + Math.random() * 0.5, up.method_10264() - 0.3 + Math.random() * 0.25, up.method_10260() + Math.random(), 0, -(-0.025F - 0.005F * (float) Math.random()), 0);
				}

				// Yes, perform spawner functions using claw's mana
				cir.setReturnValue(true);
			}
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_MANA, mana);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		mana = cmp.method_10550(TAG_MANA);
	}

	@Override
	public class_1937 getManaReceiverLevel() {
		return method_10997();
	}

	@Override
	public class_2338 getManaReceiverPos() {
		return method_11016();
	}

	@Override
	public int getCurrentMana() {
		return mana;
	}

	@Override
	public boolean isFull() {
		return mana >= MAX_MANA;
	}

	@Override
	public void receiveMana(int mana) {
		this.mana = Math.min(3 * MAX_MANA, this.mana + mana);
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return true;
	}

}
