package vazkii.botania.client.model.armor;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.common.item.equipment.armor.elementium.ElementiumArmorItem;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;
import vazkii.botania.common.item.equipment.armor.manaweave.ManaweaveArmorItem;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelArmorItem;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;

public class ArmorModels {
	private static Map<class_1304, ArmorModel> manasteel = Collections.emptyMap();
	private static Map<class_1304, ArmorModel> manaweave = Collections.emptyMap();
	private static Map<class_1304, ArmorModel> elementium = Collections.emptyMap();
	private static Map<class_1304, ArmorModel> terrasteel = Collections.emptyMap();

	private static Map<class_1304, ArmorModel> make(class_5617.class_5618 ctx, class_5601 inner, class_5601 outer) {
		Map<class_1304, ArmorModel> ret = new EnumMap<>(class_1304.class);
		for (var slot : class_1304.values()) {
			var mesh = ctx.method_32167(slot == class_1304.field_6172 ? inner : outer);
			ret.put(slot, new ArmorModel(mesh, slot));
		}
		return ret;
	}

	public static void init(class_5617.class_5618 ctx) {
		manasteel = make(ctx, BotaniaModelLayers.MANASTEEL_INNER_ARMOR, BotaniaModelLayers.MANASTEEL_OUTER_ARMOR);
		manaweave = make(ctx, BotaniaModelLayers.MANAWEAVE_INNER_ARMOR, BotaniaModelLayers.MANAWEAVE_OUTER_ARMOR);
		elementium = make(ctx, BotaniaModelLayers.ELEMENTIUM_INNER_ARMOR, BotaniaModelLayers.ELEMENTIUM_OUTER_ARMOR);
		terrasteel = make(ctx, BotaniaModelLayers.TERRASTEEL_INNER_ARMOR, BotaniaModelLayers.TERRASTEEL_OUTER_ARMOR);
	}

	@Nullable
	public static ArmorModel get(class_1799 stack) {
		class_1792 item = stack.method_7909();
		if (item instanceof ManaweaveArmorItem armor) {
			return manaweave.get(armor.method_7685());
		} else if (item instanceof ElementiumArmorItem armor) {
			return elementium.get(armor.method_7685());
		} else if (item instanceof TerrasteelArmorItem armor) {
			return terrasteel.get(armor.method_7685());
		} else if (item instanceof ManasteelArmorItem armor) { // manasteel must be last because the other types extend from it
			return manasteel.get(armor.method_7685());
		}

		return null;
	}
}
