/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.dispenser;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_238;
import net.minecraft.class_2601;
import net.minecraft.class_2969;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.material.EnderAirItem;

public class EnderAirBottlingBehavior extends class_2969 {
	private final class_2347 defaultBehaviour = new class_2347();
	private final class_2357 parent;

	public EnderAirBottlingBehavior(class_2357 parent) {
		this.parent = parent;
	}

	@Override
	protected void method_10136(class_2342 source) {
		if (this.method_27954()) {
			super.method_10136(source);
		}
	}

	@Override
	protected void method_10133(class_2342 source, class_2350 facingIn) {
		if (this.method_27954()) {
			super.method_10133(source, facingIn);
		}
	}

	private static boolean pickupInEnd(class_1937 world, class_2338 facingPos) {
		return world.method_27983() == class_1937.field_25181
				&& world.method_22347(facingPos) && world.method_22347(facingPos.method_10084())
				&& EnderAirItem.isClearFromDragonBreath(world, new class_238(facingPos).method_1014(2.0D));
	}

	@NotNull
	@Override
	protected class_1799 method_10135(class_2342 source, @NotNull class_1799 stack) {
		class_1937 world = source.method_10207();
		class_2338 blockpos = source.method_10122().method_10093(source.method_10120().method_11654(class_2315.field_10918));
		if (pickupInEnd(world, blockpos) || EnderAirItem.pickupFromEntity(world, new class_238(blockpos))) {
			this.method_27955(true);
			return fillBottle(source, stack, new class_1799(BotaniaItems.enderAirBottle));
		}
		this.method_27955(false);
		return parent.dispense(source, stack);
	}

	private class_1799 fillBottle(class_2342 source, class_1799 input, class_1799 output) {
		input.method_7934(1);
		if (input.method_7960()) {
			return output.method_7972();
		} else {
			if (((class_2601) source.method_10121()).method_11075(output.method_7972()) < 0) {
				this.defaultBehaviour.dispense(source, output.method_7972());
			}
			return input;
		}
	}
}
